with apdcs as
(
    select channel_id as channel_id, max(day) as maxdate from cubes.affiliates_partners_daily_channel_summary
    where
        day >= '2018-07-24'
        and coalesce(channel_id, 0) > 0
    group by channel_id
    having
    sum(
        coalesce(creator_ad_revenue, 0.0)
        + coalesce(creator_sub_revenue_total, 0.0)
        + coalesce(creator_sub_revenue_prime, 0.0)
        + coalesce(creator_bits_revenue_total, 0.0)
        + coalesce(creator_fuel_revenue, 0.0)
        + coalesce(creator_bounty_board_revenue, 0.0)
    ) >= 50
), royalty as
(
    select channel_id, effectivefrom, formtype, isusperson, isuseractionrequired, status, a.withholdingrate
    from
    (
        select
            b.ownerchannelid as channel_id,
            a.effectivefrom,
            a.formtype,
            a.isusperson,
            a.isuseractionrequired,
            a.status,
            a.withholdingrate,
            row_number() over(partition by b.ownerchannelid order by a.effectivefrom desc) as sort
        from paymentsdata.tax_status_updates_v1 as a
        inner join paymentsdata.payout_entities_v0 as b
            on a.accountid = concat(cast(b.payoutentityid as varchar), ':ROY')
        inner join apdcs as c
            on b.ownerchannelid = c.channel_id
    ) as a
    where sort = 1
), service as
(
    select channel_id, effectivefrom, formtype, isusperson, isuseractionrequired, status, a.withholdingrate
    from
    (
        select
            b.ownerchannelid as channel_id,
            a.effectivefrom,
            a.formtype,
            a.isusperson,
            a.isuseractionrequired,
            a.status,
            a.withholdingrate,
            row_number() over(partition by b.ownerchannelid order by a.effectivefrom desc) as sort
        from paymentsdata.tax_status_updates_v1 as a
        inner join paymentsdata.payout_entities_v0 as b
            on a.accountid = concat(cast(b.payoutentityid as varchar), ':SER')
        inner join apdcs as c
            on b.ownerchannelid = c.channel_id
    ) as a
    where sort = 1
)
select apdcs.channel_id,
    case
        when service.effectivefrom > royalty.effectivefrom
        then service.formtype
        else royalty.formtype
    end as form_type,
    case
        when service.effectivefrom > royalty.effectivefrom
        then service.isusperson
        else royalty.isusperson
    end as isusperson,
    case
        when service.effectivefrom > royalty.effectivefrom
        then service.isuseractionrequired
        else royalty.isuseractionrequired
    end as isuseractionrequired,
    case
        when service.effectivefrom > royalty.effectivefrom
        then service.status
        else royalty.status
    end as status,
    case
        when service.effectivefrom > royalty.effectivefrom
        then service.withholdingrate
        else royalty.withholdingrate
    end as withholdingrate
from apdcs
left join royalty
    on apdcs.channel_id = royalty.channel_id
left join service
    on apdcs.channel_id = royalty.channel_id
;

    
    
    