/* BEGIN TWITCH USER WEEKLY SUMMARY QUERY */
with apdcs as
(
    select
        channel_id as channel_id
    from cubes.affiliates_partners_daily_channel_summary
    where
        day >= cast(@mindatestring as datetime)
        and coalesce(channel_id, 0) > 0
        and right(channel_id, 1) = @channelDigit
    group by channel_id
    having
    sum(
        coalesce(creator_ad_revenue, 0.0)
        + coalesce(creator_sub_revenue_total, 0.0)
        + coalesce(creator_sub_revenue_prime, 0.0)
        + coalesce(creator_bits_revenue_total, 0.0)
        + coalesce(creator_fuel_revenue, 0.0)
        + coalesce(creator_bounty_board_revenue, 0.0)
    ) >= @dollarthreshold
), apdcs_subs_weekly as
(
    select
        channel_id as channel_id,
        date_trunc('week', day) as week,
        sum(subs_sold_total) as subs_total
    from cubes.affiliates_partners_daily_channel_summary
    where
        day >= cast(@mindatestring as datetime)
        and coalesce(channel_id, 0) > 0
        and right(channel_id, 1) = @channelDigit
    group by 
        channel_id,
        date_trunc('week', day)
), messages_raw as
(
    select
        channel_id,
        date_trunc('week', date) as week,
        user_id,
        count(*) as messages_sent
    from tahoe.server_chat_message 
    where 
        date >= cast(@mindatestring as datetime)
        and chatroom_type = 'twitch_chat'
        and right(channel_id, 1) = @channelDigit
    group by
        channel_id,
        date_trunc('week', date),
        user_id
), unique_weeks as
(
    select week
    from messages_raw
    group by week
), unique_messages as
(
    select
        channel_id,
        week,
        sum(messages_sent) as total_chat_messages
    from messages_raw
    where right(channel_id, 1) = @channelDigit
    group by
        channel_id,
        week
), unique_users as
(
    select
        channel_id,
        week,
        count(*) as unique_user_count
    from messages_raw
    where right(channel_id, 1) = @channelDigit
    group by
        channel_id,
        week
), minutes_watched as
(
    select
        coalesce(host_channel_id, channel_id) as channel_id,
        date_trunc('week', day) as week,
        sum(mw) as minutes_watched,
        sum(case when host_channel_id is not null then mw else 0 end) as hosted_minutes_watched
    from cubes.hours_watched_daily_by_device
    where 
        day >= cast(@mindatestring as datetime)
        and right(coalesce(host_channel_id, channel_id), 1) = @channelDigit
    group by
        coalesce(host_channel_id, channel_id),
        date_trunc('week', day)
)
select
    apdcs_week.channel_id,
    apdcs_week.week,
    unique_messages.total_chat_messages,
    unique_users.unique_user_count,
    apdcs_subs_weekly.subs_total,
    minutes_watched.minutes_watched,
    minutes_watched.hosted_minutes_watched
from
(
    select channel_id, week
    from apdcs
    cross join unique_weeks
) as apdcs_week
left join unique_messages
    on apdcs_week.channel_id = unique_messages.channel_id
    and apdcs_week.week = unique_messages.week
left join unique_users
    on apdcs_week.channel_id = unique_users.channel_id
    and apdcs_week.week = unique_users.week
left join apdcs_subs_weekly
    on apdcs_week.channel_id = apdcs_subs_weekly.channel_id
    and apdcs_week.week = apdcs_subs_weekly.week
left join minutes_watched
    on apdcs_week.channel_id = minutes_watched.channel_id
    and apdcs_week.week = minutes_watched.week
;
/* END TWITCH USER WEEKLY SUMMARY QUERY */