create temporary table mode_precomp_asn_country_new_1

  sortkey(client_asn)

as

select * from (
	select client_asn, esp.client_country as code, trim(split_part(c.country, ', ', 2) || ' ' || split_part(c.country, ', ', 1)) as country,
		row_number() over (partition by client_asn order by count(*) desc),
		count(*)
	from tahoe.edge_segment_playlist esp
	left join metadata.countries c on c.code = client_country
	where time > convert_timezone('US/Pacific', getdate()) - interval '60 days'
    and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '60 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '40 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  group by 1, 2, 3
)
where row_number = 1;

create temporary table mode_precomp_asn_country_new_2

  sortkey(client_asn)

as

select * from (
	select client_asn, esp.client_country as code, trim(split_part(c.country, ', ', 2) || ' ' || split_part(c.country, ', ', 1)) as country,
		row_number() over (partition by client_asn order by count(*) desc),
		count(*)
	from tahoe.edge_segment_playlist esp
	left join metadata.countries c on c.code = client_country
	where time > convert_timezone('US/Pacific', getdate()) - interval '40 days'
    and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '20 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  group by 1, 2, 3
)
where row_number = 1;

create temporary table mode_precomp_asn_country_new_3

  sortkey(client_asn)

as

select * from (
	select client_asn, esp.client_country as code, trim(split_part(c.country, ', ', 2) || ' ' || split_part(c.country, ', ', 1)) as country,
		row_number() over (partition by client_asn order by count(*) desc),
		count(*)
	from tahoe.edge_segment_playlist esp
	left join metadata.countries c on c.code = client_country
	where time > convert_timezone('US/Pacific', getdate()) - interval '20 days'
	and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  group by 1, 2, 3
)
where row_number = 1;

drop table if exists mode_precomp.asn_country_new;
create table mode_precomp.asn_country_new

  sortkey(client_asn)
  
as

select * from mode_precomp_asn_country_new_1 union all select * from mode_precomp_asn_country_new_2 union all select * from mode_precomp_asn_country_new_3;

drop table if exists mode_precomp.asn_country;
alter table mode_precomp.asn_country_new rename to asn_country;

drop table if exists mode_precomp.asns_new;
drop table if exists mode_precomp.asns_new_1;
drop table if exists mode_precomp.asns_new_2;
drop table if exists mode_precomp.asns_new_3;
drop table if exists mode_precomp.asns_new_4;
drop table if exists mode_precomp.asns_new_5;
drop table if exists mode_precomp.asns_new_6;

create temporary table asn_scores
sortkey(client_asn_id)
as 
  select client_asn_id, avg(ipscore) as avg_ipscore from spectrum.vbi_score
  where creation_time_utc >= getdate() - interval '60 days'
  group by 1;

create temporary table mode_precomp_asns_new_1

  sortkey(channel)

as 

with esp as (
  select channel, client_asn, max(client_asn_id) as client_asn_id, count (distinct esp.client_ip) as ips, count(*) from
  tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '60 days'
      and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '60 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '50 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '50 days')
  group by 1, 2
),  
x as (
  select channel, client_asn,
    avg_ipscore, 
    ips,
    count
  from esp
  left join asn_scores on asn_scores.client_asn_id = esp.client_asn_id
)

select channel, x.client_asn, c.country, x.avg_ipscore, x.ips, x.count
from x
left join mode_precomp.asn_country c on c.client_asn = x.client_asn;

create temporary table mode_precomp_asns_new_2

  sortkey(channel)

as 

with esp as (
  select channel, client_asn, max(client_asn_id) as client_asn_id, count (distinct esp.client_ip) as ips, count(*) from
  tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '50 days'
      and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '50 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '40 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  group by 1, 2
),  
x as (
  select channel, client_asn,
    avg_ipscore, 
    ips,
    count
  from esp
  left join asn_scores on asn_scores.client_asn_id = esp.client_asn_id
)

select channel, x.client_asn, c.country, x.avg_ipscore, x.ips, x.count
from x
left join mode_precomp.asn_country c on c.client_asn = x.client_asn;

create temporary table mode_precomp_asns_new_3

  sortkey(channel)

as 

with esp as (
  select channel, client_asn, max(client_asn_id) as client_asn_id, count (distinct esp.client_ip) as ips, count(*) from
  tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '40 days'
      and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '30 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '30 days')
  group by 1, 2
),
x as (
  select channel, client_asn,
    avg_ipscore, 
    ips,
    count
  from esp
  left join asn_scores on asn_scores.client_asn_id = esp.client_asn_id
)

select channel, x.client_asn, c.country, x.avg_ipscore, x.ips, x.count
from x
left join mode_precomp.asn_country c on c.client_asn = x.client_asn;

create temporary table mode_precomp_asns_new_4

  sortkey(channel)

as 

with esp as (
  select channel, client_asn, max(client_asn_id) as client_asn_id, count (distinct esp.client_ip) as ips, count(*) from
  tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '30 days'
      and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '30 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '20 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  group by 1, 2
),
x as (
  select channel, client_asn,
    avg_ipscore, 
    ips,
    count
  from esp
  left join asn_scores on asn_scores.client_asn_id = esp.client_asn_id
)

select channel, x.client_asn, c.country, x.avg_ipscore, x.ips, x.count
from x
left join mode_precomp.asn_country c on c.client_asn = x.client_asn;


create temporary table mode_precomp_asns_new_5

  sortkey(channel)

as 

with esp as (
  select channel, client_asn, max(client_asn_id) as client_asn_id, count (distinct esp.client_ip) as ips, count(*) from
  tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '20 days'
      and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '10 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '10 days')
  group by 1, 2
), x as (
  select 
    channel, 
    client_asn,
    avg_ipscore, --client_asn determines this uniquely
    ips,
    count
  from esp
  left join asn_scores on asn_scores.client_asn_id = esp.client_asn_id
)

select channel, x.client_asn, c.country, x.avg_ipscore, x.ips, x.count
from x
left join mode_precomp.asn_country c on c.client_asn = x.client_asn;

create temporary table mode_precomp_asns_new_6

  sortkey(channel)

as 

with esp as (
  select channel, client_asn, max(client_asn_id) as client_asn_id, count (distinct esp.client_ip) as ips, count(*) from
  tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '10 days'
      and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '10 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '0 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '0 days')
  group by 1, 2
), x as (
  select 
    channel, 
    client_asn,
    avg_ipscore, --client_asn determines this uniquely
    ips,
    count
  from esp
  left join asn_scores on asn_scores.client_asn_id = esp.client_asn_id
)

select channel, x.client_asn, c.country, x.avg_ipscore, x.ips, x.count
from x
left join mode_precomp.asn_country c on c.client_asn = x.client_asn;

drop table if exists mode_precomp.asns_new;
create table mode_precomp.asns_new 
  sortkey(channel)
  distkey(channel)
as
with u as (
select * from mode_precomp_asns_new_1 union all select * from mode_precomp_asns_new_2 union all select * from mode_precomp_asns_new_3 union all select * from mode_precomp_asns_new_4 union all select * from mode_precomp_asns_new_5 union all select * from mode_precomp_asns_new_6
)
select channel, client_asn, max(country) as country, avg(avg_ipscore) as avg_ipscore, sum(ips) as ips, sum(count) as count from u group by 1,2
;

drop table if exists mode_precomp.asns;
alter table mode_precomp.asns_new rename to asns;