drop table if exists mode_precomp.channel_country_new;

create table mode_precomp.channel_country_new
sortkey(channel)
 as (
with channel_country as (
select channel, broadcaster_country, count(*) from tahoe_all.minute_broadcast where date > getdate() - interval '60 days' group by 1,2 order by count desc
),
channel_country_rows as (
select channel, broadcaster_country, row_number() over (partition by channel order by count desc) from channel_country
)

select * from channel_country_rows where row_number = 1
);

drop table if exists mode_precomp.channel_country;
alter table mode_precomp.channel_country_new rename to channel_country;

create table mode_precomp.channel_game_new
sortkey(channel)
 as (
with channel_game as (
select channel, game, count(*) from tahoe_all.minute_broadcast where date > getdate() - interval '60 days' group by 1,2 order by count desc
),
channel_game_rows as (
select channel, game, row_number() over (partition by channel order by count desc) from channel_game
)

select * from channel_game_rows where row_number = 1
);

drop table if exists mode_precomp.channel_game;
alter table mode_precomp.channel_game_new rename to channel_game;

create table mode_precomp.channel_language_new
sortkey(channel)
 as (
with channel_language as (
select channel, language, count(*) from tahoe_all.minute_broadcast where date > getdate() - interval '60 days' group by 1,2 order by count desc
),
channel_language_rows as (
select channel, language, row_number() over (partition by channel order by count desc) from channel_language
)

select * from channel_language_rows where row_number = 1
);

drop table if exists mode_precomp.channel_language;
alter table mode_precomp.channel_language_new rename to channel_language;