/* BEGIN NEW 1 */
drop table if exists mode_precomp.viewbots_new;

create temporary table mode_precomp_viewbots_new_1

  compound sortkey (channel, timep)

as 

with cc as (
  select channel, date_trunc('hour', time) as timep, 
    avg(case when env = 'production' then before end) as prod_before,
    avg(case when env = 'production' then merged end) as prod_merged,
    avg(case when env = 'staging' then merged end) as staging_merged
  from tahoe_all.pn_channel_concurrents cc
  where time > convert_timezone('US/Pacific', getdate()) - interval '60 days'
  and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '60 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '40 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  group by 1, 2
),

esp as (
  select channel, date_trunc('hour', time) as timep, count(distinct video_session_id) as esp_sessions, count(distinct client_ip) as esp_ips
  from tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '60 days'
  and mod(extract(minute from time), 15) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '60 days')
    and time <= convert_timezone('US/Pacific', getdate()) - interval '40 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  and content_host like video_node || '%'
  and coalesce(video_node, '') <> ''
  group by 1, 2
),

esr as (
  select channel, date_trunc('hour', time) as timep, count(distinct video_session_id) as esr_sessions, count(distinct client_ip) as esr_ips
  from tahoe_all.edge_segment_request esr
  where time > convert_timezone('US/Pacific', getdate()) - interval '60 days'
    and mod(extract(minute from time), 15) = 0

  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '60 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '40 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  and coalesce(video_node, '') <> ''
  and coalesce(segment_headers, '') not like '%"Range":["bytes=0-1"]%'
  group by 1, 2
),

susp_bots as (
  select esp.channel, esp.timep, (esp_sessions - esr_sessions)::float / (esp_sessions) as susp_bot_ratio_sessions,
     (esp_ips - esr_ips)::float / (esp_ips) as susp_bot_ratio_ips
  from esp
  left join esr on esp.timep = esr.timep and esp.channel = esr.channel
),

x as (
  select cc.channel, cc.timep, prod_before, prod_merged, staging_merged,
    ((1 - susp_bot_ratio_sessions) * prod_before)::int as bg1,
    ((1 - susp_bot_ratio_ips) * prod_before)::int as bg2,
    greatest(prod_before, prod_merged, staging_merged) as highest
  from cc
  left join susp_bots b on b.timep = cc.timep and b.channel = cc.channel
), 

y as (
  select channel, timep,
    case when prod_before    >= 0.85 * highest then highest else prod_before    end as "Unfiltered",
    case when prod_merged    >= 0.85 * highest then highest else prod_merged    end as "Site CCU",
    case when staging_merged >= 0.85 * highest then highest else staging_merged end as "Beta CCU",
    case when bg1            >= 0.85 * highest then highest else bg1            end as "Best guess 1",
    case when bg2            >= 0.85 * highest then highest else bg2            end as "Best guess 2"
  from x
)

select channel, timep, "Unfiltered", "Site CCU", "Beta CCU",
  least("Best guess 1", "Best guess 2") as "Best guess"
from y;

/* END NEW 1 */

/* BEGIN NEW 2 */
create temporary table mode_precomp_viewbots_new_2

  compound sortkey (channel, timep)

as 
with cc as (
  select channel, date_trunc('hour', time) as timep, 
    avg(case when env = 'production' then before end) as prod_before,
    avg(case when env = 'production' then merged end) as prod_merged,
    avg(case when env = 'staging' then merged end) as staging_merged
  from tahoe_all.pn_channel_concurrents cc
  where time > convert_timezone('US/Pacific', getdate()) - interval '40 days'
    and mod(extract(minute from time), 15) = 0

  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '20 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  group by 1, 2
),

esp as (
  select channel, date_trunc('hour', time) as timep, count(distinct video_session_id) as esp_sessions, count(distinct client_ip) as esp_ips
  from tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '40 days'
    and mod(extract(minute from time), 15) = 0

  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
    and time <= convert_timezone('US/Pacific', getdate()) - interval '20 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  and content_host like video_node || '%'
  and coalesce(video_node, '') <> ''
  group by 1, 2
),

esr as (
  select channel, date_trunc('hour', time) as timep, count(distinct video_session_id) as esr_sessions, count(distinct client_ip) as esr_ips
  from tahoe_all.edge_segment_request esr
  where time > convert_timezone('US/Pacific', getdate()) - interval '40 days'
    and mod(extract(minute from time), 15) = 0

  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '40 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '20 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  and coalesce(video_node, '') <> ''
  and coalesce(segment_headers, '') not like '%"Range":["bytes=0-1"]%'
  group by 1, 2
),

susp_bots as (
  select esp.channel, esp.timep, (esp_sessions - esr_sessions)::float / (esp_sessions) as susp_bot_ratio_sessions,
     (esp_ips - esr_ips)::float / (esp_ips) as susp_bot_ratio_ips
  from esp
  left join esr on esp.timep = esr.timep and esp.channel = esr.channel
),

x as (
  select cc.channel, cc.timep, prod_before, prod_merged, staging_merged,
    ((1 - susp_bot_ratio_sessions) * prod_before)::int as bg1,
    ((1 - susp_bot_ratio_ips) * prod_before)::int as bg2,
    greatest(prod_before, prod_merged, staging_merged) as highest
  from cc
  left join susp_bots b on b.timep = cc.timep and b.channel = cc.channel
), 

y as (
  select channel, timep,
    case when prod_before    >= 0.85 * highest then highest else prod_before    end as "Unfiltered",
    case when prod_merged    >= 0.85 * highest then highest else prod_merged    end as "Site CCU",
    case when staging_merged >= 0.85 * highest then highest else staging_merged end as "Beta CCU",
    case when bg1            >= 0.85 * highest then highest else bg1            end as "Best guess 1",
    case when bg2            >= 0.85 * highest then highest else bg2            end as "Best guess 2"
  from x
)

select channel, timep, "Unfiltered", "Site CCU", "Beta CCU",
  least("Best guess 1", "Best guess 2") as "Best guess"
from y;
/* END NEW 2 */

/* BEGIN NEW 3 */

create temporary table mode_precomp_viewbots_new_3

  compound sortkey (channel, timep)

as 
with cc as (
  select channel, date_trunc('hour', time) as timep, 
    avg(case when env = 'production' then before end) as prod_before,
    avg(case when env = 'production' then merged end) as prod_merged,
    avg(case when env = 'staging' then merged end) as staging_merged
  from tahoe_all.pn_channel_concurrents cc
  where time > convert_timezone('US/Pacific', getdate()) - interval '20 days'
    and mod(extract(minute from time), 5) = 0

  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '0 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '0 days')
  group by 1, 2
),

esp as (
  select channel, date_trunc('hour', time) as timep, count(distinct video_session_id) as esp_sessions, count(distinct client_ip) as esp_ips
  from tahoe_all.edge_segment_playlist esp
  where time > convert_timezone('US/Pacific', getdate()) - interval '20 days'
    and mod(extract(minute from time), 5) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
    and time <= convert_timezone('US/Pacific', getdate()) - interval '0 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '0 days')
  and content_host like video_node || '%'
  and coalesce(video_node, '') <> ''
  group by 1, 2
),

esr as (
  select channel, date_trunc('hour', time) as timep, count(distinct video_session_id) as esr_sessions, count(distinct client_ip) as esr_ips
  from tahoe_all.edge_segment_request esr
  where time > convert_timezone('US/Pacific', getdate()) - interval '20 days'
    and mod(extract(minute from time), 5) = 0
  and date >= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '20 days')
  and time <= convert_timezone('US/Pacific', getdate()) - interval '0 days'
  and date <= date_trunc('day', convert_timezone('US/Pacific', getdate()) - interval '0 days')
  and coalesce(video_node, '') <> ''
  and coalesce(segment_headers, '') not like '%"Range":["bytes=0-1"]%'
  group by 1, 2
),

susp_bots as (
  select esp.channel, esp.timep, (esp_sessions - esr_sessions)::float / (esp_sessions) as susp_bot_ratio_sessions,
     (esp_ips - esr_ips)::float / (esp_ips) as susp_bot_ratio_ips
  from esp
  left join esr on esp.timep = esr.timep and esp.channel = esr.channel
),

x as (
  select cc.channel, cc.timep, prod_before, prod_merged, staging_merged,
    ((1 - susp_bot_ratio_sessions) * prod_before)::int as bg1,
    ((1 - susp_bot_ratio_ips) * prod_before)::int as bg2,
    greatest(prod_before, prod_merged, staging_merged) as highest
  from cc
  left join susp_bots b on b.timep = cc.timep and b.channel = cc.channel
), 

y as (
  select channel, timep,
    case when prod_before    >= 0.85 * highest then highest else prod_before    end as "Unfiltered",
    case when prod_merged    >= 0.85 * highest then highest else prod_merged    end as "Site CCU",
    case when staging_merged >= 0.85 * highest then highest else staging_merged end as "Beta CCU",
    case when bg1            >= 0.85 * highest then highest else bg1            end as "Best guess 1",
    case when bg2            >= 0.85 * highest then highest else bg2            end as "Best guess 2"
  from x
)

select channel, timep, "Unfiltered", "Site CCU", "Beta CCU",
  least("Best guess 1", "Best guess 2") as "Best guess"
from y;
/* END NEW 3 */

/* Merge it all together */
drop table if exists mode_precomp.viewbots_new;
create table mode_precomp.viewbots_new
  compound sortkey (channel, timep)
as
(
  select * from mode_precomp_viewbots_new_1 union all select * from mode_precomp_viewbots_new_2 union all select * from mode_precomp_viewbots_new_3
);

drop table if exists mode_precomp.viewbots;
alter table mode_precomp.viewbots_new rename to viewbots;