/* Viewbot Overall Query */
with apdcs as
(
    select channel_id as channel_id, max(day) as maxdate
    from cubes.affiliates_partners_daily_channel_summary
    where
        day >= cast('{lookback}' as datetime)
        and coalesce(channel_id, 0) > 0
    group by channel_id
    having
    sum(
        coalesce(creator_ad_revenue, 0.0)
        + coalesce(creator_sub_revenue_total, 0.0)
        + coalesce(creator_sub_revenue_prime, 0.0)
        + coalesce(creator_bits_revenue_total, 0.0)
        + coalesce(creator_fuel_revenue, 0.0)
        + coalesce(creator_bounty_board_revenue, 0.0)
    ) >= {jobConfig.MinimumDollarThreshold}
),
viewbot as
(
    select
        channel_id,
        avg(before) as before_avg,
        avg(merged) as merged_avg,
        null as best_avg
    from tahoe_all.pn_channel_concurrents
    where
        date >= cast('{mindatestring}' as datetime)
        and date < cast('{maxdatestring}' as datetime)
        and env = 'production'
    group by
        channel_id, channel
)
select
    a.channel_id as ChannelID,
    a.before_avg as BeforeAvg,
    a.merged_avg as MergedAvg,
    a.best_avg as BestGuessAvg,
    null as Data
from viewbot as a
where exists
(
    select 1
    from apdcs as b
    where a.channel_id = b.channel_id
)
;
/* End Viewbot Overall Query */

/* Viewbot Data Query */
with apdcs as
(
    select channel_id as channel_id, max(day) as maxdate
    from cubes.affiliates_partners_daily_channel_summary
    where
        day >= cast('{lookback}' as datetime)
        and coalesce(channel_id, 0) > 0
    group by channel_id
    having
    sum(
        coalesce(creator_ad_revenue, 0.0)
        + coalesce(creator_sub_revenue_total, 0.0)
        + coalesce(creator_sub_revenue_prime, 0.0)
        + coalesce(creator_bits_revenue_total, 0.0)
        + coalesce(creator_fuel_revenue, 0.0)
        + coalesce(creator_bounty_board_revenue, 0.0)
    ) >= {jobConfig.MinimumDollarThreshold}
),
viewbot as
(
    select
        a.channel_id,
        date_trunc('day', a.date) as day,
        sum(coalesce(a.before, 0)) as sum_beforeguess,
        sum(coalesce(a.merged, 0)) as sum_mergedguess,
        coalesce(null, 0) as sum_bestguess,
        count(*) as sum_count
    from tahoe_all.pn_channel_concurrents as a
    inner join apdcs as b
        on a.channel_id = b.channel_id
    where
        date >= cast('{mindatestring}' as datetime)
        and date < cast('{maxdatestring}' as datetime)
        and env = 'production'
    group by 
        a.channel_id,
        date_trunc('day', a.date)
)
select
    channel_id,
    day,
    sum_beforeguess,
    sum_mergedguess,
    sum_bestguess,
    sum_count
from viewbot as a
;
/* End Viewbot Data Query */