#!/bin/bash
# Script Usage:
# cd ~/Documents/Projects/github.com/resonance-api-server/LaunchScripts/
# environment=Development sh RunWeb.sh

ENV="--environment=$environment"

# This launches all the web projects at once
# Find process id if you lose it: 'ps aux | grep resonance'
# Kill {pid}
# pkill -f resonance
echo "====="
AUTH="dotnet ../Builds/$environment/Auth/Resonance.Api.Microservices.Auth.dll $ENV"
echo "$AUTH"
AMP="dotnet ../Builds/$environment/Amp/Resonance.Api.Microservices.Amp.dll $ENV"
echo "$AMP"
ATLAS="dotnet ../Builds/$environment/Atlas/Resonance.Api.Microservices.Atlas.dll $ENV"
echo "$ATLAS"
EXPLORER="dotnet ../Builds/$environment/Explorer/Resonance.Api.Microservices.Explorer.dll $ENV"
echo "$EXPLORER"
$AUTH & $AMP & $ATLAS & $EXPLORER &
