﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.PlatformAbstractions;
using Resonance.Core.Models.ConfigurationModels;
using System;
using System.IO;

namespace Resonance.Api.Microservices.Atlas
{
    internal static class AppConfig
    {
        internal static IConfigurationRoot config = null;
        internal static DateTime AppStart { get; private set; }
        internal static ApplicationConfigurationModel Data { get; private set; }

        internal static void Initialize(ref string originalEnvironment, ref string[] args)
        {
            AppStart = DateTime.UtcNow;

            try
            {
                config = new ConfigurationBuilder()
                    .SetBasePath(Directory.GetCurrentDirectory())
                    .AddCommandLine(args)
                    .AddJsonFile($"{PlatformServices.Default.Application.ApplicationBasePath}hosting.json", optional: false)
                    .AddJsonFile($"{PlatformServices.Default.Application.ApplicationBasePath}appsettings.{originalEnvironment}.json", optional: false, reloadOnChange: true)
                    .Build();
            }
            catch (Exception)
            {
                config = new ConfigurationBuilder()
                    .SetBasePath(Directory.GetCurrentDirectory())
                    .AddCommandLine(args)
                    .AddJsonFile($"hosting.json", optional: false)
                    .AddJsonFile($"appsettings.{originalEnvironment}.json", optional: false, reloadOnChange: true)
                    .Build();
            }

            if (config == null)
            {
                throw new ArgumentNullException("config");
            }

            Data = config.GetSection("Resonance").Get<ApplicationConfigurationModel>();

            if (!AppConfig.Data.Application.Environment.StartsWith(originalEnvironment))
            {
                throw new ArgumentException($@"Launched Environment does not match the command line provided environment (Expected: {originalEnvironment}, Actual: {config["Resonance:Application:Environment"]}). Typically this means your IDE launch args do not match your selected environment.");
            }
        }

        internal static IConfigurationRoot GetConfiguration()
        {
            return config;
        }
    }
}
