﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Resonance.Api.Microservices.Explorer.Models;
using Resonance.Core.Helpers.ReflectionHelpers;
using Resonance.Core.Models.ApiModels;
using Resonance.Core.Models.DatabaseModels.TwitchUserListingModels;
using Resonance.Core.Models.FilterModels;
using System.Linq;
using System.Text;

namespace Resonance.Api.Microservices.Explorer.Controllers
{
    public class AutofetchController : Controller
    {
        private readonly IConfiguration _config;
        private readonly ILogger<AutofetchController> log;

        public AutofetchController(IConfiguration config, ILogger<AutofetchController> logger)
        {
            _config = config;
            log = logger;
        }

        [HttpGet("auto-fetch/twitch-user-listing")]
        public JsonResult GetFilterTypes()
        {
            var model = new AutoFetchViewModel()
            {
                Method = "POST",
                AuthRequired = true,
                InputModel = typeof(ListingFilter).Name,
                InputProperties = ReflectionHelper.GetTypeJsonPropertyNamesAndTypes<ListingFilter>(),
                InputPropertiesHtml = null,
                OutputModel = typeof(TwitchUserListingModel).Name,
                OutputProperties = ReflectionHelper.GetTypeJsonPropertyNamesAndTypes<TwitchUserListingModel>(),
                OutputPropertiesHtml = null,
                SubmitFormHtml = null,
                Notes = "Input supplies a list of columns to be returned, valid columns are based on the model 'TwitchUserListingModel'"
            };
            var inputPropertiesHtml = new StringBuilder();
            if(model.InputModel != null)
            {
                inputPropertiesHtml.AppendLine("<div class=\"hidden\" id=\"input-properties-html\">");
                inputPropertiesHtml.AppendLine("<table><thead><tr><td>Field</td><td>Data Type</td><tbody>");
                foreach (var item in model.InputProperties)
                {
                    inputPropertiesHtml.AppendLine($"<tr><td>{item.Key}</td><td>{item.Value}</td></tr>");
                }
                inputPropertiesHtml.AppendLine("</tbody></table>");
                inputPropertiesHtml.AppendLine("</div>");
            }
            model.InputPropertiesHtml = inputPropertiesHtml.ToString();

            var outputPropertiesHtml = new StringBuilder();
            if (model.OutputModel != null)
            {
                outputPropertiesHtml.AppendLine("<div class=\"hidden\" id=\"output-properties-html\">");
                outputPropertiesHtml.AppendLine("<table><thead><tr><td>Field</td><td>Data Type</td><tbody>");
                foreach (var item in model.OutputProperties)
                {
                    outputPropertiesHtml.AppendLine($"<tr><td>{item.Key}</td><td>{item.Value}</td></tr>");
                }
                outputPropertiesHtml.AppendLine("</tbody></table>");
                outputPropertiesHtml.AppendLine("</div>");
            }
            model.OutputPropertiesHtml = outputPropertiesHtml.ToString();

            var formbuilder = new StringBuilder();
            formbuilder.AppendLine("<tr>");
            formbuilder.AppendLine("</tr>");
            model.SubmitFormHtml = formbuilder.ToString();
            return new JsonResult(model);
        }
    }
}