﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Resonance.Api.Microservices.Explorer.Models;

namespace Resonance.Api.Microservices.Explorer.Controllers
{
    public class HomeController : Controller
    {
        private readonly IConfiguration _config;
        private readonly ILogger<HomeController> log;

        public HomeController(IConfiguration config, ILogger<HomeController> logger)
        {
            _config = config;
            log = logger;
        }

        public IActionResult Index()
        {
            return View();
        }

        [HttpGet("force-test-exception")]
        public JsonResult ForceFailure()
        {
            throw new Exception("DEVELOPMENT EXCEPTION");
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
