﻿using System;
using System.IdentityModel.Tokens.Jwt;
using System.Security.Claims;
using System.Text;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;
using Resonance.Api.Microservices.Explorer.Models;
using Resonance.Core;
using Resonance.Core.Extensions;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Models.AuthModels;

namespace Resonance.Api.Microservices.Explorer.Controllers
{
    [Authorize]
    [Produces("application/json")]
    public class JwtController : Controller
    {
        private readonly IConfiguration _configuration;

        public JwtController(IConfiguration configuration)
        {
            _configuration = configuration;
        }

        [AllowAnonymous]
        [HttpGet("login")]
        public IActionResult Login()
        {
            var model = new LoginViewModel();
            return View(model);
        }

        [AllowAnonymous]
        [HttpPost("login")]
        public IActionResult RequestToken(IFormCollection form)
        {
            TokenRequest request = new TokenRequest()
            {
                Username = form.GetFirstOrDefault("Username"),
                Password = form.GetFirstOrDefault("Password")
            };
            if (request.Username == "Jon" && request.Password == "password")
            {
                var claims = new[]
                {
                    new Claim(ClaimTypes.Name, request.Username),
                    new Claim("CompletedBasicTraining", ""),
                    new Claim(CustomClaimTypes.EmploymentCommenced,
                                new DateTime(2017,12,1).ToString(),
                                ClaimValueTypes.DateTime)
                };

                var jwtCredentials = JWTHelper.GetSigningCredentials(context: HttpContext);
                var creds = new SigningCredentials(jwtCredentials.Key, SecurityAlgorithms.HmacSha256);

                var token = new JwtSecurityToken(
                    issuer: "amp.cursedata.io",
                    audience: "amp.cursedata.io",
                    claims: claims,
                    expires: DateTime.Now.AddMinutes(30),
                    signingCredentials: creds);

                return Ok(new
                {
                    token = new JwtSecurityTokenHandler().WriteToken(token)
                });
            }

            return BadRequest("Could not verify username and password");
        }

        [HttpGet("test-auth")]
        public IActionResult Test()
        {
            var userName = User.Identity.Name;

            return Ok($"Super secret content, I hope you've got clearance for this {userName}...");
        }

        [Authorize(Policy = "TrainedStaffOnly")]
        [HttpPost("DeleteUser")]
        public IActionResult DeleteUser(string username)
        {
            // go wild, delete the user, do what you have to...
            return Ok("Deleted");
        }
    }
}