﻿using System;
using System.Linq;
using System.Text;
using Microsoft.AspNetCore.Mvc;
using Resonance.Core.Commands.SlackCommands;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Helpers.SlackHelpers;
using Resonance.Core.Models.ServiceModels.ExplorerModels;

namespace Resonance.Api.Microservices.Explorer.Controllers
{
    [Route("slack")]
    public class SlackController : Controller
    {
        [HttpPost("get-user")]
        public ContentResult GetUser()
        {
            string result = string.Empty;
            try
            {
                var data = new SlackCommandMetaModel()
                {
                    ChannelID = Request?.Form["channel_id"].FirstOrDefault(),
                    ChannelName = Request?.Form["channel_name"].FirstOrDefault(),
                    Command = Request?.Form["command"].FirstOrDefault(),
                    ResponseUrl = Request?.Form["response_url"].FirstOrDefault(),
                    TeamDomain = Request?.Form["team_domain"].FirstOrDefault(),
                    TeamID = Request?.Form["team_id"].FirstOrDefault(),
                    Text = Request?.Form["text"].FirstOrDefault(),
                    TriggerID = Request?.Form["trigger_id"].FirstOrDefault(),
                    UserID = Request?.Form["user_id"].FirstOrDefault(),
                    Username = Request?.Form["user_name"].FirstOrDefault(),
                    VerificationToken = Request?.Form["token"].FirstOrDefault()
                };
                result = SlackCommand.GetUser(data.Text);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                result = "An error occurred while performing the lookup.";
            }

            return Content(result);
        }

        [HttpPost("get-definition")]
        public ContentResult GetDefinition()
        {
            string result = string.Empty;
            try
            {
                var data = new SlackCommandMetaModel()
                {
                    ChannelID = Request?.Form["channel_id"].FirstOrDefault(),
                    ChannelName = Request?.Form["channel_name"].FirstOrDefault(),
                    Command = Request?.Form["command"].FirstOrDefault(),
                    ResponseUrl = Request?.Form["response_url"].FirstOrDefault(),
                    TeamDomain = Request?.Form["team_domain"].FirstOrDefault(),
                    TeamID = Request?.Form["team_id"].FirstOrDefault(),
                    Text = Request?.Form["text"].FirstOrDefault(),
                    TriggerID = Request?.Form["trigger_id"].FirstOrDefault(),
                    UserID = Request?.Form["user_id"].FirstOrDefault(),
                    Username = Request?.Form["user_name"].FirstOrDefault(),
                    VerificationToken = Request?.Form["token"].FirstOrDefault()
                };
                result = $@"ChannelID: {data.ChannelID}, ChannelName: {data.ChannelName}, Command: {data.Command}, ResponseUrl: {data.ResponseUrl}, TeamDomain: {data.TeamDomain}, TeamID: {data.TeamID}, Text: {data.Text}, TriggerID: {data.TriggerID}, UserID: {data.UserID}, Username: {data.Username}, VerificationToken: {data.VerificationToken}";//SlackCommand.GetUser(content);


                result = SlackCommand.GetDefinition(data.Text);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                result = "An error occurred while performing the lookup.";
            }

            return Content(result);
        }

        [HttpPost("viewbot")]
        public ContentResult GetViewbot()
        {
            string result = string.Empty;
            try
            {
                var data = new SlackCommandMetaModel()
                {
                    ChannelID = Request?.Form["channel_id"].FirstOrDefault(),
                    ChannelName = Request?.Form["channel_name"].FirstOrDefault(),
                    Command = Request?.Form["command"].FirstOrDefault(),
                    ResponseUrl = Request?.Form["response_url"].FirstOrDefault(),
                    TeamDomain = Request?.Form["team_domain"].FirstOrDefault(),
                    TeamID = Request?.Form["team_id"].FirstOrDefault(),
                    Text = Request?.Form["text"].FirstOrDefault(),
                    TriggerID = Request?.Form["trigger_id"].FirstOrDefault(),
                    UserID = Request?.Form["user_id"].FirstOrDefault(),
                    Username = Request?.Form["user_name"].FirstOrDefault(),
                    VerificationToken = Request?.Form["token"].FirstOrDefault()
                };
                result = $@"ChannelID: {data.ChannelID}, ChannelName: {data.ChannelName}, Command: {data.Command}, ResponseUrl: {data.ResponseUrl}, TeamDomain: {data.TeamDomain}, TeamID: {data.TeamID}, Text: {data.Text}, TriggerID: {data.TriggerID}, UserID: {data.UserID}, Username: {data.Username}, VerificationToken: {data.VerificationToken}";//SlackCommand.GetUser(content);


                result = SlackCommand.GetViewbot(data.Text);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                result = "An error occurred while performing the lookup.";
            }

            return Content(result);
        }

        [HttpPost("twitch-command")]
        public JsonResult TwitchCommand()
        {
            var newline = (char)10;
            var response = new SlackResponseModel()
            {
                ResponseType = "ephemeral",
                IsMarkdown = true
            };
            try
            {
                var data = new SlackCommandMetaModel()
                {
                    ChannelID = Request?.Form["channel_id"].FirstOrDefault(),
                    ChannelName = Request?.Form["channel_name"].FirstOrDefault(),
                    Command = Request?.Form["command"].FirstOrDefault(),
                    ResponseUrl = Request?.Form["response_url"].FirstOrDefault(),
                    TeamDomain = Request?.Form["team_domain"].FirstOrDefault(),
                    TeamID = Request?.Form["team_id"].FirstOrDefault(),
                    Text = Request?.Form["text"].FirstOrDefault(),
                    TriggerID = Request?.Form["trigger_id"].FirstOrDefault(),
                    UserID = Request?.Form["user_id"].FirstOrDefault(),
                    Username = Request?.Form["user_name"].FirstOrDefault(),
                    VerificationToken = Request?.Form["token"].FirstOrDefault()
                };
                Log.Info($@"Slack Command Received from {data.Username} ({data.UserID}) :: {data.Command} {data.Text}");
                response.Text = $@"*ChannelID:* {data.ChannelID}, *ChannelName:* {data.ChannelName}, {newline}*UserID:* {data.UserID}, *Username:* {data.Username}, {newline}*Command:* {data.Command}, *Text:* {data.Text}, {newline} *TeamDomain:* {data.TeamDomain}, *TeamID:* {data.TeamID}, *ResponseUrl:* {data.ResponseUrl},  {newline}*TriggerID:* {data.TriggerID}, *VerificationToken:* {data.VerificationToken}";//SlackCommand.GetUser(content);
                var command = data?.Text?.Trim()?.Split(' ');
                if (data.Command == "/amp" && command.Length > 0)
                {
                    switch (command[0].ToLower())
                    {
                        case "user":
                        {
                            response.Text = SlackCommand.GetUser(data.Text);
                            break;
                        }
                        case "country":
                        {
                            response.Text = SlackCommand.GetTop5Countries(data);
                            break;
                        }
                        default:
                        {
                            response.Text = "Unknown command. Try '/amp help'";
                            break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                response.Text = "An error occurred while performing the command.";
            }

            response.Text = response.Text.EscapeForSlack();
            return new JsonResult(response);
        }
    }
}