﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Resonance.Api.Microservices.Explorer.Models;
using Resonance.Core;
using Resonance.Core.Models.ApiModels;
using Resonance.Core.Models.ApiModels.ExplorerModels;

namespace Resonance.Api.Microservices.Explorer.Controllers
{
    [Route("utility")]
    public class UtilityController : Controller
    {
        [HttpGet("json-pretty-print")]
        public IActionResult JsonPrettyPrint()
        {
            var model = new JsonPrettyPrintViewModel();
            return View(model);
        }


        [HttpPost("json-pretty-print")]
        public JsonResult ProcessJsonPrettyPrint([FromBody]JsonPrettyPrintModel data)
        {
            if(data == null || string.IsNullOrWhiteSpace(data.Content))
            {
                return new JsonResult("{\"error\":\"Invalid json data\"}");
            }
            return new JsonResult(JsonConvert.SerializeObject(JsonConvert.DeserializeObject<dynamic>(data.Content), Formatting.Indented));
        }

        [HttpGet("json-uglify")]
        public IActionResult JsonUglify()
        {
            var model = new JsonPrettyPrintViewModel();
            return View(model);
        }


        [HttpPost("json-uglify")]
        public JsonResult ProcessJsonUglify([FromBody]JsonPrettyPrintModel data)
        {
            if (data == null || string.IsNullOrWhiteSpace(data.Content))
            {
                return new JsonResult("{\"error\":\"Invalid json data\"}");
            }
            return new JsonResult(JsonConvert.SerializeObject(JsonConvert.DeserializeObject<dynamic>(data.Content), Formatting.None));
        }

        [HttpGet("get-guid")]
        public JsonResult GetGuid()
        {
            var response = new ApiResponse<string>()
            {
                RequestStartTime = DateTime.UtcNow,
                ResponseData = Guid.NewGuid().ToString("d"),
                RequestEndTime = DateTime.UtcNow,
                Success = true,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier
            };
            return new JsonResult(response);
        }
    }
}