﻿"use strict";
var ResonanceBuildExample = {
    FilterRequestSuccess: function (data) {
        var content = "<h3>Results</h3><pre><code>" + JSON.stringify(data, null, 2) + "</code></pre>";
        $("#example-response").html(content);
    },
    FilterRequestFailure: function (jqXHR, textStatus, errorThrown) {
        console.log("filter fail");
    },
    SortRequest: function (data) {
        console.log("filter");
        console.log(data);
    },
    SortRequestSuccess: function (data) {
        console.log("filter success");
        console.log(data);
    },
    SortRequestFailure: function (jqXHR, textStatus, errorThrown) {
        console.log("filter fail");
    },
    PopulateInteractiveForm: function (selector) {
        var service = $(selector + ' option:selected').val();
        var data = ResonanceBuildExample.GetData(service);
        if (data === null) {
            return;
        }

        ResonanceForms.Get(data, ResonanceBuildExample.PopulateInteractiveFormSuccess, ResonanceBuildExample.PopulateInteractiveFormFail)
    },
    PopulateInteractiveFormSuccess: function (data) {
        if (data !== undefined && data.method !== undefined) {
            $("#method").html(data.method);
            $("#auth-required").html(data.auth_required);
            $("#input-model").html(data.input_model);
            $("#input-properties").html(data.input_properties_html);
            $("#output-model").html(data.output_model);
            $("#output-properties").html(data.output_properties_html);
            $("#notes").html(data.notes);
            $("#custom-form-data").replaceWith(data.form_content);
        }
        console.log(data);
    },
    PopulateInteractiveFormFail: function (jqXHR, textStatus, errorThrown) {
        console.log(textStatus);
        console.log(errorThrown);
    },
    GetData(service) {
        switch (service) {
            case "worker/amp/get-twitch-user-listing":
                return "http://127.0.0.1:8086/auto-fetch/twitch-user-listing";
            case "worker/amp/get-twitch-user-listing-columns":
                var data = {
                };
                return data;
            case "worker/amp/get-twitch-user-listing-aggregation-types":
                var data = {
                };
                return data;
            default:
                return null;
        }
    }
};

$(document).ready(function () {
    $("#test-form").on("submit", function (event) {
        event.preventDefault();
        var form = $(this);
        var filter_request = {
            "limit": 10,
            "page": 1,
            "aggtype": 30,
            "req-cols": ["channelid", "login", "channelconcurrentsminuteswatchedtotal", "channelconcurrentsminutesbroadcasttotal", "maxccu", "averageccu"],
            "filters": [{ "filter-type": 2, "key": "channelconcurrentsminuteswatchedtotal", "is-inclusive": false, "v1": 100, "v2": 500 }],
            "sortdata": [{ "col": "maxccu", "ord": 0, "asc": true }, { "col": "login", "ord": 1, "asc": false }]
        };
        ResonanceForms.PostForm(filter_request, form.attr('action'), ResonanceBuildExample.FilterRequestSuccess, ResonanceBuildExample.FilterRequestFailure);
    });

    $('#endpoint-url').on("change", function () {
        var val = $('#endpoint-url').val();
        $("#select-groups > select").each(function () {
            $(this).addClass("hidden");
        });

        switch (val) {
            // Amp
            case "http://127.0.0.1:8083/": {
                $("#amp-endpoint-method").removeClass("hidden");
                break;
            }
            // Auth
            case "http://127.0.0.1:8084/": {
                $("#auth-endpoint-method").removeClass("hidden");
                break;
            }
            // Salesforce
            case "http://127.0.0.1:8085/": {
                $("#salesforce-endpoint-method").removeClass("hidden");
                break;
            }
            // TwitchUserLookup
            case "http://127.0.0.1:8081/": {
                $("#twitchuserlookup-endpoint-method").removeClass("hidden");
                break;
            }
            // TwitchVerifiedLink
            case "http://127.0.0.1:8082/": {
                $("#twitchverifiedlink-endpoint-method").removeClass("hidden");
                break;
            }
        }
    });

    $('#amp-endpoint-method').on("change", function () {
        ResonanceBuildExample.PopulateInteractiveForm("#amp-endpoint-method");
    });

    $('#auth-endpoint-method').on("change", function () {
        ResonanceBuildExample.PopulateInteractiveForm("#auth-endpoint-method");
    });

    $('#salesforce-endpoint-method').on("change", function () {
        ResonanceBuildExample.PopulateInteractiveForm("#salesforce-endpoint-method");
    });

    $('#twitchuserlookup-endpoint-method').on("change", function () {
        ResonanceBuildExample.PopulateInteractiveForm("#twitchuserlookup-endpoint-method");
    });

    $('#twitchverifiedlink-endpoint-method').on("change", function () {
        ResonanceBuildExample.PopulateInteractiveForm("#twitchverifiedlink-endpoint-method");
    });

    $("#display-input-properties").on('click', function () {
        $("#display-input-properties").toggleClass("active");
        if ($("#display-input-properties").hasClass("active")) {
            $("#input-properties").css("display", "block");
        }
        else {
            $("#input-properties").css("display", "none");
        }
    });
});