﻿"use strict";

var LoadDataEndpoint = "";
var GuidFetchEndpoint = "";

var ResonanceMigrationPermissions = {
    LoadEnvironmentData: function () {
        console.log("Loading environment data.")

        var data = {
            project: $("#project option:selected").val(),
            source_environment: $("#source_environment option:selected").val(),
            target_environment: $("#target_environment option:selected").val()
        };
        console.log(data);

        ResonanceForms.PostForm(data, LoadDataEndpoint, ResonanceMigrationPermissions.LoadDataSuccess, ResonanceMigrationPermissions.LoadDataFailure);

        console.log("Completed loading environment data.");
    },
    LoadDataSuccess: function (result) {
        console.log("Load Data Success");
        console.log(result);

        if (result.data == "undefined") {
            console.log("Data undefined. Unable to proceed.");
            return;
        }
        var sourcePermissions = result.data.sourceConfiguration;
        var targetPermissions = result.data.targetConfiguration;

        if (sourcePermissions === "undefined" || targetPermissions === "undefined") {
            console.log("There was an issue loading either the source or target permissions.");
            return;
        }

        $("#source-environment-label").text("Source: " + $("#source_environment option:selected").val());
        $("#target-environment-label").text("Target: " + $("#target_environment option:selected").val());

        var newline = '\n';
        $('.inputDisabled').attr('disabled', false);
        $('.submitDisabled').attr('disabled', false);

        // Process the arrays into text blocks
        // ... Source
        var sourcePermissions = result.data.sourceConfiguration.permissions.map(function (val) {
            return val['permission-id'] + "|" + val['permission-name'] + "|" + (val['permission-description'] || "");
        }).join(newline);

        var sourceTokens = result.data.sourceConfiguration.tokens.map(function (val) {
            return val['token-id'] + "|" + val['token-name'] + "|" + (val['token-description'] || "") + "|" + (val['WhitelistedIPSource'] || "");
        }).join(newline);

        var sourceRoles = result.data.sourceConfiguration.roles.map(function (val) {
            return val['role-id'] + "|" + val['role-name'] + "|" + (val['role-description'] || "");
        }).join(newline);

        var sourceLdapGroups = result.data.sourceConfiguration['ldap-groups'].map(function (val) {
            return val['ldap-group-id'] + "|" + val['ldap-group-name'] + "|" + (val['ldap-group-description'] || "");
        }).join(newline);

        var sourceLdapUsers = result.data.sourceConfiguration['ldap-names'].map(function (val) {
            return val['ldap-name-id'] + "|" + val['ldap-name'] + "|" + (val['ldap-name-description'] || "");
        }).join(newline);

        var sourceColumnPermissions = result.data.sourceConfiguration['column-permissions'].map(function (val) {
            return val['column-permission-id'] + "|" + val['column-permissions-name'] + "|" + (val['column-permission-list'] || "") + "|" + (val['ldap-name-description'] || "");
        }).join(newline);

        // ... Target
        var targetPermissions = result.data.targetConfiguration.permissions.map(function (val) {
            return val['permission-id'] + "|" + val['permission-name'] + "|" + (val['permission-description'] || "");
        }).join(newline);

        var targetTokens = result.data.targetConfiguration.tokens.map(function (val) {
            return val['token-id'] + "|" + val['token-name'] + "|" + (val['token-description'] || "") + "|" + (val['WhitelistedIPSource'] || "");
        }).join(newline);

        var targetRoles = result.data.targetConfiguration.roles.map(function (val) {
            return val['role-id'] + "|" + val['role-name'] + "|" + (val['role-description'] || "");
        }).join(newline);

        var targetLdapGroups = result.data.targetConfiguration['ldap-groups'].map(function (val) {
            return val['ldap-group-id'] + "|" + val['ldap-group-name'] + "|" + (val['ldap-group-description'] || "");
        }).join(newline);

        var targetLdapUsers = result.data.targetConfiguration['ldap-names'].map(function (val) {
            return val['ldap-name-id'] + "|" + val['ldap-name'] + "|" + (val['ldap-name-description'] || "");
        }).join(newline);

        var targetColumnPermissions = result.data.targetConfiguration['column-permissions'].map(function (val) {
            return val['column-permission-id'] + "|" + val['column-permissions-name'] + "|" + (val['column-permission-list'] || "") + "|" + (val['ldap-name-description'] || "");
        }).join(newline);

        // Put it all on screen
        // ... Source
        $("#source_raw_permissions").val(sourcePermissions);
        $("#source_raw_tokens").val(sourceTokens);
        $("#source_raw_roles").val(sourceRoles);
        $("#source_raw_ldap_groups").val(sourceLdapGroups);
        $("#source_raw_ldap_users").val(sourceLdapUsers);
        $("#source_raw_column_permissions").val(sourceColumnPermissions);

        $.each(result.data.sourceConfiguration['role-to-ldap-group-map'], function (key, value) {
            var joined = result.data.sourceConfiguration['role-to-ldap-group-map'][key].join();
            $("#source_role_to_ldap_group_mapping").val($("#source_role_to_ldap_group_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.sourceConfiguration['role-to-ldap-name-map'], function (key, value) {
            var joined = result.data.sourceConfiguration['role-to-ldap-name-map'][key].join();
            $("#source_role_to_ldap_user_mapping").val($("#source_role_to_ldap_user_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.sourceConfiguration['role-to-permission-map'], function (key, value) {
            var joined = result.data.sourceConfiguration['role-to-permission-map'][key].join();
            $("#source_role_to_permission_mapping").val($("#source_role_to_permission_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.sourceConfiguration['role-to-token-map'], function (key, value) {
            var joined = result.data.sourceConfiguration['role-to-token-map'][key].join();
            $("#source_role_to_token_mapping").val($("#source_role_to_token_mapping").val() + key + "|" + joined + "\n");
        });

        // ... Target
        $("#target_raw_permissions").val(targetPermissions);
        $("#target_raw_tokens").val(targetTokens);
        $("#target_raw_roles").val(targetRoles);
        $("#target_raw_ldap_groups").val(targetLdapGroups);
        $("#target_raw_ldap_users").val(targetLdapUsers);
        $("#target_raw_column_permissions").val(targetColumnPermissions);

        $.each(result.data.targetConfiguration['role-to-ldap-group-map'], function (key, value) {
            var joined = result.data.targetConfiguration['role-to-ldap-group-map'][key].join();
            $("#target_role_to_ldap_group_mapping").val($("#target_role_to_ldap_group_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.targetConfiguration['role-to-ldap-name-map'], function (key, value) {
            var joined = result.data.targetConfiguration['role-to-ldap-name-map'][key].join();
            $("#target_role_to_ldap_user_mapping").val($("#target_role_to_ldap_user_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.targetConfiguration['role-to-permission-map'], function (key, value) {
            var joined = result.data.targetConfiguration['role-to-permission-map'][key].join();
            $("#target_role_to_permission_mapping").val($("#target_role_to_permission_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.targetConfiguration['role-to-token-map'], function (key, value) {
            var joined = result.data.targetConfiguration['role-to-token-map'][key].join();
            $("#target_role_to_token_mapping").val($("#target_role_to_token_mapping").val() + key + "|" + joined + "\n");
        });
    },
    LoadDataFailure: function (jqXHR, textStatus, errorThrown) {
        var responseData = jqXHR.responseJSON
        console.log("Failed to load data");

        if (responseData !== "undefined") {
            console.log(responseData);
        }
    },
    GenerateGuidSuccess: function (result) {
        console.log("Successfully generated GUID");
        $("#guid_result").val(result.data);
    },
    GenerateGuidFailure: function (jqXHR, textStatus, errorThrown) {
        console.log("Failed to generate guid");
    },
};

$(document).ready(function () {
    $("#load_data").on('click', function (e) {
        e.preventDefault();
        ResonanceMigrationPermissions.LoadEnvironmentData();
    });

    $("#generate_guid").on('click', function () {
        console.log("Generating Guid");
        ResonanceForms.Get(GuidFetchEndpoint + "utility/get-guid", ResonanceMigrationPermissions.GenerateGuidSuccess, ResonanceMigrationPermissions.GenerateGuidFailure)
    });
});