﻿"use strict";
var PermissionMap = {};
var GuidFetchEndpoint = "";
var PermissionFetchEndpoint = "";

var ResonancePermissions = {
    SetPermissions: function (permissionData) {
        PermissionMap = permissionData;
        console.log(permissionData);
    },
    RoleLdapGroupSelect: function (rolename) {
        if (PermissionMap["role-to-ldap-group-map"][rolename] !== undefined) {
            console.log("Found grouping " + rolename);
        }
    },
    CopyPermissionSubmit: function (sourceProjectName, targetProjectName) {
        if (sourceProjectName === "None" || targetProjectName === "None") {
            console.log("Invalid source or target project. Can not use 'None'");
            return;
        }
        else {
            window.location = GuidFetchEndpoint + "permission-admin/copy-permissions?sourceProject=" + sourceProjectName + "&targetProject=" + targetProjectName;
        }
    },
    PermissionFetchSuccess: function (result) {
        var newline = '\n';
        console.log("Completed loading permissions");
        console.log(result)
        $('.inputDisabled').attr('disabled', false);
        $('.submitDisabled').attr('disabled', false);

        var permissions = result.data.configuration.permissions.map(function (val) {
            return val['permission-id'] + "|" + val['permission-name'] + "|" + (val['permission-description'] || "");
        }).join(newline);

        var tokens = result.data.configuration.tokens.map(function (val) {
            return val['token-id'] + "|" + val['token-name'] + "|" + (val['token-description'] || "") + "|" + (val['WhitelistedIPSource'] || "");
        }).join(newline);

        var roles = result.data.configuration.roles.map(function (val) {
            return val['role-id'] + "|" + val['role-name'] + "|" + (val['role-description'] || "");
        }).join(newline);

        var ldapGroups = result.data.configuration['ldap-groups'].map(function (val) {
            return val['ldap-group-id'] + "|" + val['ldap-group-name'] + "|" + (val['ldap-group-description'] || "");
        }).join(newline);

        var ldapUsers = result.data.configuration['ldap-names'].map(function (val) {
            return val['ldap-name-id'] + "|" + val['ldap-name'] + "|" + (val['ldap-name-description'] || "");
        }).join(newline);

        var columnPermissions = result.data.configuration['column-permissions'].map(function (val) {
            return val['column-permission-id'] + "|" + val['column-permissions-name'] + "|" + (val['column-permission-list'] || "") + "|" + (val['ldap-name-description'] || "");
        }).join(newline);

        $("#raw_permissions").val(permissions);
        $("#raw_tokens").val(tokens);
        $("#raw_roles").val(roles);
        $("#raw_ldap_groups").val(ldapGroups);
        $("#raw_ldap_users").val(ldapUsers);
        $("#raw_column_permissions").val(columnPermissions);

        $.each(result.data.configuration['role-to-ldap-group-map'], function (key, value) {
            var joined = result.data.configuration['role-to-ldap-group-map'][key].join();
            $("#role_to_ldap_group_mapping").val($("#role_to_ldap_group_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.configuration['role-to-ldap-name-map'], function (key, value) {
            var joined = result.data.configuration['role-to-ldap-name-map'][key].join();
            $("#role_to_ldap_user_mapping").val($("#role_to_ldap_user_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.configuration['role-to-permission-map'], function (key, value) {
            var joined = result.data.configuration['role-to-permission-map'][key].join();
            $("#role_to_permission_mapping").val($("#role_to_permission_mapping").val() + key + "|" + joined + "\n");
        });

        $.each(result.data.configuration['role-to-token-map'], function (key, value) {
            var joined = result.data.configuration['role-to-token-map'][key].join();
            $("#role_to_token_mapping").val($("#role_to_token_mapping").val() + key + "|" + joined + "\n");
        });

        /*
        if (data.data === true) {
            $("#update-table-success").removeClass("hidden");
        }
        else {
            $("#update-table-failure").removeClass("hidden");
        }
        */
    },
    PermissionFetchFailure: function (jqXHR, textStatus, errorThrown) {
        console.log("Failed to load permissions for " + project);
        /*
        $("#update-table-failure").removeClass("hidden");
        */
    },
    GenerateGuidSuccess: function (result) {
        console.log("Successfully generated GUID");
        $("#guid_result").val(result.data);
    },
    GenerateGuidFailure: function (jqXHR, textStatus, errorThrown) {
        console.log("Failed to generate guid");
        /*
        $("#update-table-failure").removeClass("hidden");
        */
    },
};

$(document).ready(function () {
    $("#copy_permission_submit").on('click', function (event) {
        event.preventDefault();
        ResonancePermissions.CopyPermissionSubmit($("#copy_permission_source").val(), $("#copy_permission_target").val());
    });

    $("#select_project").on('change', function () {
        $('.inputDisabled').attr('disabled', true);
        $('.submitDisabled').attr('disabled', true);
        $('.inputDisabled').val("");
        var project = $("#select_project").val();
        if (project !== "None") {
            console.log("Loading permissions for " + project);
            ResonanceForms.Get(PermissionFetchEndpoint + "?projectName=" + project, ResonancePermissions.PermissionFetchSuccess, ResonancePermissions.PermissionFetchFailure);
        }
    });

    $("#generate_guid").on('click', function () {
        console.log("Generating Guid");
        ResonanceForms.Get(GuidFetchEndpoint + "utility/get-guid", ResonancePermissions.GenerateGuidSuccess, ResonancePermissions.GenerateGuidFailure)
    });
});