﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Resonance.Core;
using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Helpers.StatsDHelpers;
using Microsoft.AspNetCore;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.PlatformAbstractions;
using Resonance.Api.Microservices.TwitchVerifiedLink;
using System.Threading;
using NLog.Web;

namespace Resonance.Api.WorkerNode
{
    public class Program
    {
        private static string originalEnvironment = null;
        public static void Main(string[] args)
        {
            try
            {
                var builder = new ConfigurationBuilder();
                builder.AddCommandLine(args);
                var config = builder.Build();

                try
                {
                    originalEnvironment = config["environment"];
                }
                catch (Exception)
                {
                    throw new ArgumentNullException($@"'Environment' argument must be specified. This can be done through the launch file, or through the IDE argument section.");
                }

                AppConfig.Initialize(ref originalEnvironment, ref args);

                switch (AppConfig.Data.Application.Environment)
                {
                    case "Development":
                    case "Staging":
                    case "Production":
                    {
                        break;
                    }
                    default:
                    {
                        throw new NotImplementedException($"Undefined application environment '{config["Resonance:Application:Environment"]}', please define handling in Resonance.Api.WorkerNode.Program.cs and Resonance.Core.Constants.cs");
                    }
                }
                Constants.InitConstants(AppConfig.Data, "TwitchVerifiedLink");
                Log.Initialize();
                Log.Info($"({AppConfig.Data.Application.Environment})Init Main");
                string ip = "telegraf.cursedata.io";
                StatsDHelper.Initialize(AppConfig.Data.Application.BaseCloudwatchLogPath, ip, 8125, "Resonance", $"TwitchVerifiedLink", TimeSpan.FromMinutes(1));
                DBManagerMysql.Initialize("resonance");
                BuildWebHost(args).Run();
            }
            catch (Exception ex)
            {
                //NLog: catch setup errors
                Log.Error($"{ex} -Stopped program because of exception");
            }
            finally
            {
                // Ensure to flush and stop internal timers/threads before application-exit (Avoid segmentation fault on Linux)
                Log.Info($"Application is shutting down");
                NLog.LogManager.Shutdown();
            }
        }

        public static IWebHost BuildWebHost(string[] args)
        {
            var host = new WebHostBuilder()
                .UseConfiguration(AppConfig.GetConfiguration())
                .UseContentRoot(Directory.GetCurrentDirectory())
                .UseKestrel()
                .UseStartup<Startup>()
                .UseNLog()
                .Build();

            return host;
        }
    }
}
