﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using Resonance.Core.Models.DatabaseModels.RequestModels;
using Resonance.Microservices.Methods;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Resonance.Core.ConstantData.Amp;

namespace Resonance.Api.Test.Amp
{
    [TestClass]
    public class AmpMethodsTest
    {
        [TestMethod]
        public void SortChannelListByStatusTest()
        {
            AmpMethods methods = new AmpMethods();
            List<RequestChannel> channels = new List<RequestChannel>();

            channels.Add(new RequestChannel { ChannelID = 1, Status = "other" });
            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Suggested });
            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Deleted });
            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Manual });

            var results = methods.SortChannelListByStatus(channels);
            Assert.AreEqual(results.Count(), 4);
            Assert.AreEqual(results[0].Status, RequestChannelStatus.Deleted);
            Assert.AreEqual(results[1].Status, RequestChannelStatus.Suggested);
            Assert.AreEqual(results[2].Status, RequestChannelStatus.Manual);
            Assert.AreEqual(results[3].Status, "other");
        }

        [TestMethod]
        public void FilterOutDuplicateChannelsSort1()
        {
            AmpMethods methods = new AmpMethods();
            List<RequestChannel> channels = new List<RequestChannel>();

            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Deleted });
            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Suggested });
            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Manual });
            channels.Add(new RequestChannel { ChannelID = 1, Status = "other" });

            var results = methods.FilterOutDuplicateChannels(channels);

            Assert.AreEqual(results.Count(), 1);

            var result = results[0];

            Assert.AreEqual(result.ChannelID, 1);
            Assert.AreEqual(result.Status, RequestChannelStatus.Deleted);
        }

        [TestMethod]
        public void FilterOutDuplicateChannelsSort2()
        {
            AmpMethods methods = new AmpMethods();
            List<RequestChannel> channels = new List<RequestChannel>();

            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Suggested });
            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Manual });
            channels.Add(new RequestChannel { ChannelID = 1, Status = "other" });

            var results = methods.FilterOutDuplicateChannels(channels);

            Assert.AreEqual(results.Count(), 1);

            var result = results[0];

            Assert.AreEqual(result.ChannelID, 1);
            Assert.AreEqual(result.Status, RequestChannelStatus.Suggested);
        }

        [TestMethod]
        public void FilterOutDuplicateChannelsSort3()
        {
            AmpMethods methods = new AmpMethods();
            List<RequestChannel> channels = new List<RequestChannel>();

            channels.Add(new RequestChannel { ChannelID = 1, Status = RequestChannelStatus.Manual });
            channels.Add(new RequestChannel { ChannelID = 1, Status = "other" });

            var results = methods.FilterOutDuplicateChannels(channels);

            Assert.AreEqual(results.Count(), 1);

            var result = results[0];

            Assert.AreEqual(result.ChannelID, 1);
            Assert.AreEqual(result.Status, RequestChannelStatus.Manual);
        }

        [TestMethod]
        public void FilterOutDuplicateChannelsSort4()
        {
            AmpMethods methods = new AmpMethods();
            List<RequestChannel> channels = new List<RequestChannel>();

            channels.Add(new RequestChannel { ChannelID = 1, Status = "other" });

            var results = methods.FilterOutDuplicateChannels(channels);

            Assert.AreEqual(results.Count(), 1);

            var result = results[0];

            Assert.AreEqual(result.ChannelID, 1);
            Assert.AreEqual(result.Status, "other");
        }

        //test no dupes
        //test with dupes
        //test with nulls

        [TestMethod]
        public void TestChannelContainsDuplicatePriorityValuesNoDuplicates()
        {
            var channels = new List<RequestChannel>
            {
                new RequestChannel{ Priority = 1 },
                new RequestChannel{ Priority = 2 },
                new RequestChannel{ Priority = 3 },
                new RequestChannel{ Priority = 4 },
                new RequestChannel{ Priority = 5 },
            };

            var hasDupes = new AmpMethods().ChannelsContainDuplicatePriorityValues(channels);
            Assert.IsFalse(hasDupes);
        }

        [TestMethod]
        public void TestChannelContainsDuplicatePriorityValuesWithDuplicates()
        {
            var channels = new List<RequestChannel>
            {
                new RequestChannel{ Priority = 1 },
                new RequestChannel{ Priority = 2 },
                new RequestChannel{ Priority = 2 },
                new RequestChannel{ Priority = 4 },
                new RequestChannel{ Priority = 5 },
            };

            var hasDupes = new AmpMethods().ChannelsContainDuplicatePriorityValues(channels);
            Assert.IsTrue(hasDupes);
        }

        [TestMethod]
        public void TestChannelContainsDuplicatePriorityValuesNullPriorityNoDuplicates()
        {
            var channels = new List<RequestChannel>
            {
                new RequestChannel{ Priority = 1 },
                new RequestChannel{ Priority = null },
                new RequestChannel{ Priority = null },
                new RequestChannel{ Priority = 2 },
                new RequestChannel{ Priority = 3 },
            };

            var hasDupes = new AmpMethods().ChannelsContainDuplicatePriorityValues(channels);
            Assert.IsFalse(hasDupes);
        }

        [TestMethod]
        public void TestChannelContainsDuplicatePriorityValuesNullPriorityWithDuplicates()
        {
            var channels = new List<RequestChannel>
            {
                new RequestChannel{ Priority = 1 },
                new RequestChannel{ Priority = 2 },
                new RequestChannel{ Priority = 2 },
                new RequestChannel{ Priority = null },
                new RequestChannel{ Priority = null },
            };

            var hasDupes = new AmpMethods().ChannelsContainDuplicatePriorityValues(channels);
            Assert.IsTrue(hasDupes);
        }

        [TestMethod]
        public void TestChannelContainsDuplicatePriorityValuesHandlesDeletedChannels1()
        {
            var channels = new List<RequestChannel>
            {
                new RequestChannel{ Priority = 1 },
                new RequestChannel{ Priority = 2 },
                new RequestChannel{ Priority = 2, Status = RequestChannelStatus.Deleted },
            };

            var hasDupes = new AmpMethods().ChannelsContainDuplicatePriorityValues(channels);
            Assert.IsFalse(hasDupes);
        }

        [TestMethod]
        public void TestChannelContainsDuplicatePriorityValuesHandlesNull()
        {
            var hasDupes = new AmpMethods().ChannelsContainDuplicatePriorityValues(null);
            Assert.IsFalse(hasDupes);
        }

        [TestMethod]
        public void TestChannelContainsDuplicatePriorityValuesHandlesEmptyList()
        {
            var hasDupes = new AmpMethods().ChannelsContainDuplicatePriorityValues(new List<RequestChannel>());
            Assert.IsFalse(hasDupes);
        }
    }
}
