﻿using CsvHelper;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Newtonsoft.Json;
using Resonance.Core;
using Resonance.Core.ConstantData.Amp;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Models.ApiModels;
using Resonance.Core.Models.DatabaseModels.RedshiftModels;
using Resonance.Core.Models.DatabaseModels.RequestModels;
using Resonance.Core.Models.DatabaseModels.TwitchUserListingModels;
using Resonance.Core.Models.FilterModels;
using Resonance.Microservices.Methods;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace Resonance.Api.Test.Amp
{
    [TestClass]
    public class TwitchUserListingController
    {
        [TestMethod]
        public void GetUserListingColumns()
        {
            bool success = false;
            try
            {
                var result = WebRequestHelper.GetData($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing-columns", WebRequestHelper.AppToken);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<string>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void GetUserListingAggregationTypes()
        {
            bool success = false;
            try
            {
                var result = WebRequestHelper.GetData($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing-aggregation-types", WebRequestHelper.AppToken);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<int>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        /*
        /// <summary>
        /// You should not be running this test unless you know exactly what you are doing.
        /// </summary>
        [TestMethod]
        public void InsertUpdateTwitchUserListing()
        {
            try
            {
                var data = new ManifestModel()
                {
                    AggregationType = Core.Constants.AggregationType.Week,
                    Bucket = "crs-data-export",
                    ManifestFiles = new List<string>()
                    {
                        "Development/unload/amp/twitch-user-listing/2019/03/01/7/"
                    }
                };
                var url = $"{TestConfig.ApiEndpointAmp}worker/amp/bulk-update-twitch-user-listing";
                var result = WebRequestHelper.PostData<ManifestModel>(url, ref data, isToken: true);
                Assert.IsTrue(!string.IsNullOrWhiteSpace(result));
                Debug.Print(result);
            }
            catch(BadDataException bdException)
            {
                string fieldName = "";
                foreach(var entry in bdException.ReadingContext.NamedIndexes)
                {
                    foreach(int id in entry.Value)
                    {
                        if(bdException.ReadingContext.CurrentIndex == id)
                        {
                            fieldName = entry.Key;
                        }
                    }
                }
                Console.WriteLine("Bad Data:" + fieldName + " " + bdException.ReadingContext.Row + " " + bdException.ReadingContext.Record[bdException.ReadingContext.CurrentIndex]);
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }
        */

        /*
        [TestMethod]
        public void GetTwitchUserListingFieldTypes()
        {
            var defaultFieldList = TwitchUserListingColumnDefinition.Default();
            Assert.IsTrue(true);
        }
        */

        [TestMethod]
        public void GetUserListing()
        {
            bool success = false;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.Default()
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<ManifestModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }


        [TestMethod]
        public void GetFilteredColumns()
        {
            bool success = false;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing()
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<ManifestModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterExactMatch()
        {
            bool success = false;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.Exact,
                        Key = "login",
                        Value = "karma",
                    }
                },
                SortOrder = new List<SortFilter>()
                {
                    new SortFilter()
                    {
                        Ascending = false,
                        Column = "channelconcurrentsminuteswatchedtotal",
                        Ordinal = 0
                    }
                }.ToArray()
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if (result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<ManifestModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterLessThanMatch()
        {
            bool success = false;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.LessThan,
                        Key = "maxccu",
                        Value = "10",
                    }
                },
                SortOrder = new SortFilter[1]
                {
                    new SortFilter()
                    {
                        Column = "maxccu",
                        Ordinal = 0,
                        Ascending = false
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<ManifestModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterGreaterThanMatch()
        {
            bool success = false;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.GreaterThan,
                        Key = "maxccu",
                        Value = 9999,

                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<ManifestModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterInMatch()
        {
            bool success = false;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.Exact,
                        Key = "login",
                        Value = "ninja,cohhcarnage,karma",
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<ManifestModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }


        [TestMethod]
        public void FilterContainsMatch()
        {
            bool success = false;
            var filter = "co";
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.Contains,
                        Key = "login",
                        Value = filter,
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                        foreach (var item in data.ResponseData)
                        {
                            if (!item.Login.Contains(filter))
                            {
                                success = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterExternalQueryFilters()
        {
            bool success = false;
            var loginFilter = "co";
            var gameFilter = "divinity";
            var gameFilter2 = "sin";
            var gameidFilter = 490644;
            var giantbombidFilter = 50803;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.Contains,
                        Key = "login",
                        Value = loginFilter,
                    }
                },
                ExternalQueryFilters = new Dictionary<string, List<ExternalQueryFilter>>()
                {
                    // Filter Type 1
                    // Filter 1
                    {
                        "game-name",
                        new List<ExternalQueryFilter>()
                        {
                            new ExternalQueryFilter()
                            {
                                QueryFilters = new List<QueryFilter>()
                                {
                                    //Filter1
                                    new QueryFilter()
                                    {
                                        FilterType = Core.Constants.FilterType.Contains,
                                        IsCaseSensitive = false,
                                        IsInclusive = false,
                                        Key = "gamename",
                                        Value = gameFilter,
                                        Value2 = null,
                                        ValueArray = null
                                    },
                                    //Filter2
                                    new QueryFilter()
                                    {
                                        FilterType = Core.Constants.FilterType.Contains,
                                        IsCaseSensitive = false,
                                        IsInclusive = false,
                                        Key = "gamename",
                                        Value = gameFilter2,
                                        Value2 = null,
                                        ValueArray = null
                                    },
                                    // Filter3
                                    new QueryFilter()
                                    {
                                        FilterType = Core.Constants.FilterType.Contains,
                                        IsCaseSensitive = false,
                                        IsInclusive = false,
                                        Key = "force-bad-query-filter",
                                        Value = gameFilter,
                                        Value2 = null,
                                        ValueArray = null
                                    }
                                }
                            }
                        }
                    },
                    // Filter Type 2
                    {
                        "twitch-game-id",
                        new List<ExternalQueryFilter>()
                        {
                            new ExternalQueryFilter()
                            {
                                QueryFilters = new List<QueryFilter>()
                                {
                                    //Filter1
                                    new QueryFilter()
                                    {
                                        FilterType = Core.Constants.FilterType.Contains,
                                        IsCaseSensitive = false,
                                        IsInclusive = false,
                                        Key = "gameid",
                                        Value = gameidFilter,
                                        Value2 = null,
                                        ValueArray = null
                                    },
                                    //Filter2
                                    new QueryFilter()
                                    {
                                        FilterType = Core.Constants.FilterType.Contains,
                                        IsCaseSensitive = false,
                                        IsInclusive = false,
                                        Key = "force-bad-query-filter",
                                        Value = gameFilter,
                                        Value2 = null,
                                        ValueArray = null
                                    }
                                }
                            }
                        }
                    },
                    // Filter Type 3
                    {
                        "giantbomb-id",
                        new List<ExternalQueryFilter>()
                        {
                            new ExternalQueryFilter()
                            {
                                QueryFilters = new List<QueryFilter>()
                                {
                                    //Filter1
                                    new QueryFilter()
                                    {
                                        FilterType = Core.Constants.FilterType.Contains,
                                        IsCaseSensitive = false,
                                        IsInclusive = false,
                                        Key = "giantbombid",
                                        Value = 50803,
                                        Value2 = null,
                                        ValueArray = null
                                    },
                                    //Filter2
                                    new QueryFilter()
                                    {
                                        FilterType = Core.Constants.FilterType.Contains,
                                        IsCaseSensitive = false,
                                        IsInclusive = false,
                                        Key = "force-bad-query-filter",
                                        Value = gameFilter,
                                        Value2 = null,
                                        ValueArray = null
                                    }
                                }
                            }
                        }
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if (result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                        foreach (var item in data.ResponseData)
                        {
                            if (!item.Login.Contains(loginFilter))
                            {
                                success = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }


        [TestMethod]
        public void FilterStartsWithMatch()
        {
            bool success = false;
            var filter = "to";
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.StartsWith,
                        Key = "login",
                        Value = filter,
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                        foreach (var item in data.ResponseData)
                        {
                            if (!item.Login.StartsWith(filter))
                            {
                                success = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterRangesExclusiveMatch()
        {
            bool success = false;
            var filter1 = 100;
            var filter2 = 200;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.Range,
                        Key = "channelconcurrentsminuteswatchedtotal",
                        Value = filter1,
                        IsInclusive = false,
                        Value2 = filter2
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                        foreach (var item in data.ResponseData)
                        {
                            if (item.ChannelConcurrentsMinutesWatchedTotal < filter1 || item.ChannelConcurrentsMinutesWatchedTotal >= filter2)
                            {
                                success = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterRangesInclusiveMatch()
        {
            bool success = false;
            var filter1 = 100;
            var filter2 = 200;
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.Range,
                        Key = "channelconcurrentsminuteswatchedtotal",
                        Value = filter1,
                        IsInclusive = true,
                        Value2 = filter2
                    }
                },
                SortOrder = new SortFilter[1]
                {
                    new SortFilter()
                    {
                        Column = "channelconcurrentsminuteswatchedtotal",
                        Ordinal = 0,
                        Ascending = false
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                        foreach (var item in data.ResponseData)
                        {
                            if (item.ChannelConcurrentsMinutesWatchedTotal < filter1 || item.ChannelConcurrentsMinutesWatchedTotal > filter2)
                            {
                                success = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void FilterMultiMatch()
        {
            bool success = false;
            var filter1 = 25;
            var filter2 = 4000;
            var filter3 = "to";
            var postdata = new ListingFilter()
            {
                Limit = 10,
                Page = 0,
                AggregateType = Core.Constants.AggregationType.ThirtyDay,
                Columns = TwitchUserListingColumnDefinition.IndexListing(),
                QueryFilters = new List<QueryFilter>()
                {
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.StartsWith,
                        Key = "login",
                        Value = filter3
                    },
                    new QueryFilter()
                    {
                        FilterType = Core.Constants.FilterType.Range,
                        Key = "channelconcurrentsminuteswatchedtotal",
                        Value = filter1,
                        IsInclusive = false,
                        Value2 = filter2
                    }
                },
                SortOrder = new SortFilter[1]
                {
                    new SortFilter()
                    {
                        Column = "login",
                        Ordinal = 0,
                        Ascending = true
                    }
                }
            };
            try
            {
                var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    var data = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result.Data);
                    if (data != null && data.ResponseData != null && data.ResponseData.Count() > 0 && string.IsNullOrWhiteSpace(data.ErrorMessage))
                    {
                        success = true;
                        foreach (var item in data.ResponseData)
                        {
                            if (item.ChannelConcurrentsMinutesWatchedTotal < filter1 || item.ChannelConcurrentsMinutesWatchedTotal > filter2 || !item.Login.StartsWith(filter3))
                            {
                                success = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }


        [TestMethod]
        public void GetPages()
        {
            {
                bool success = false;
                var postdata = new ListingFilter()
                {
                    Limit = 10,
                    Page = 0,
                    AggregateType = Core.Constants.AggregationType.ThirtyDay,
                    Columns = new string[1] {"channelid"}
                };
                try
                {
                    var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                    if(result != null && result.IsSuccess)
                    {
                        var data = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result.Data);
                        postdata.Page = 1;
                        var result2 = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                        if(result2 != null && result2.IsSuccess)
                        {
                            var data2 = JsonConvert.DeserializeObject<ApiListResponse<TwitchUserListingModel>>(result2.Data);

                            if
                            (
                                data != null
                                && data.ResponseData != null
                                && data.ResponseData.Count() > 0
                                && data2 != null
                                && data.ResponseData != null
                                && data2.ResponseData.Count() > 0
                                && data.ResponseData
                                .Select(x => x.ChannelID).ToArray()
                                .Intersect(
                                    data2.ResponseData
                                    .Select(y => y.ChannelID).ToArray()
                                ).Count() == 0
                                && string.IsNullOrWhiteSpace(data.ErrorMessage)
                            )
                            {
                                success = true;
                            }
                        }
                    }
                }
                catch (Exception ex)
                {
                    Debug.Print(ex.ToString());
                }
                Assert.IsTrue(success);
            }
        }

        [TestMethod]
        public void GetFakeColumns()
        {
            {
                bool success = false;
                var postdata = new ListingFilter()
                {
                    Limit = 10,
                    Page = 0,
                    AggregateType = Core.Constants.AggregationType.ThirtyDay,
                    Columns = new string[]
                    {
                        "channelid",
                        "fakecolumn1",
                        "fakecolumn2",
                        "login"
                    }
                };
                try
                {
                    var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                    if(result != null && result.IsSuccess)
                    {
                        var data = JsonConvert.DeserializeObject<ApiListResponse<ManifestModel>>(result.Data);

                        if
                        (
                            data != null
                            && data.ResponseData != null
                            && data.ResponseData.Count() > 0
                            && string.IsNullOrWhiteSpace(data.ErrorMessage)
                        )
                        {
                            success = true;
                        }
                    }
                }
                catch (Exception ex)
                {
                    Debug.Print(ex.ToString());
                }
                Assert.IsTrue(success);
            }
        }

        [TestMethod]
        public void GetInvalidAggregation()
        {
            {
                bool success = false;
                var postdata = new ListingFilter()
                {
                    Limit = 10,
                    Page = 0,
                    AggregateType = Core.Constants.AggregationType.Unknown,
                    Columns = new string[]
                    {
                        "channelid",
                        "login"
                    }
                };
                try
                {
                    var result = WebRequestHelper.PostData<ListingFilter>($"{TestConfig.ApiEndpointAmp}worker/amp/get-twitch-user-listing", WebRequestHelper.AppToken, ref postdata, isToken: true);
                    if(result != null && result.IsSuccess)
                    {
                        success = true;
                    }
                    /*if (result.StartsWith("{\"statusCode\":500"))
                    {
                        success = true;
                    }*/
                }
                catch (Exception ex)
                {
                    Debug.Print(ex.ToString());
                }
                Assert.IsTrue(success);
            }
        }
    }
}
