﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using Newtonsoft.Json;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Models.ConfigurationModels.Jobs;
using System;

namespace Resonance.Api.Test.Configurations
{
    /// <summary>
    /// You should not be running this test unless you know exactly what you are doing.
    /// </summary>
    [TestClass]
    public class ConfigurationCreator
    {
        [TestMethod]
        public void TwitchUserListingCredentials()
        {
            Assert.IsTrue(true);
            return;

            var baseCloudwatch = "/aws/ec2/Development/resonance/jobs";
            var cloudwatch = "/twitch-user-listing";
            var kms = "arn:aws:kms:us-west-2:029773783190:key/3230f66f-4da7-4911-ae98-56afbcbd30f2";
            var jobConfig = new JobConfiguration()
            {
                IsActive = false,
                IsRunning = false,
                LogPath = $"{baseCloudwatch}{cloudwatch}",
                JobName = "twitch-user-listing",
                StatsDName = "resonance_twitch_user_listing",
                NextRunTime = DateTime.UtcNow.AddMinutes(-1),
                S3ConfigurationBucket = $@"resonance-configuration",
                S3ConfigurationPath = $@"Development/twitch-user-listing/{Resonance.Core.Constants.ApplicationVersion}.json.gz"
            };
            var config = JsonConvert.SerializeObject(jobConfig, Formatting.None);
            S3Helper.WriteStringToS3(config, jobConfig.S3ConfigurationBucket, jobConfig.S3ConfigurationPath, true, kms, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);

            Assert.IsTrue(true);
        }
    }
}
