﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using Newtonsoft.Json;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Models.ConfigurationModels.Aws;
using Resonance.Core.Models.ConfigurationModels.Salesforce;
using Resonance.Core.Models.DatabaseModels;
using System;
using System.Collections.Generic;
using System.IO;

namespace Resonance.Api.Test.Credentials
{
    /// <summary>
    /// You should not be running this test unless you know exactly what you are doing.
    /// </summary>
    [TestClass]
    public class CredentialCreator
    {
        [TestMethod]
        public void CreateMySqlCredentials()
        {
            Assert.IsTrue(true);
            return;
            /*
            string environment = null;
            MySqlModel resonanceMysql = null;
            string kmsArn = null;

#if CONFIG_DEVELOPMENT
            environment = "Development";
            resonanceMysql = JsonConvert.DeserializeObject<MySqlModel>(File.ReadAllText($@"C:\Secrets\resonance_mysql_development.serialized"));
            kmsArn = "arn:aws:kms:us-west-2:029773783190:key/3230f66f-4da7-4911-ae98-56afbcbd30f2";
#elif CONFIG_STAGING
            environment = "Staging";
            resonanceMysql = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_mysql_staging.serialized"));
            kmsArn = "arn:aws:kms:us-west-2:029773783190:key/cc79d809-bfcc-4d2d-97f2-7376f412f1b5";
#elif CONFIG_PRODUCTION
            environment = "Production";
            resonanceMysql = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_mysql_production.serialized"));
            kmsArn = "arn:aws:kms:us-west-2:029773783190:key/027e7a19-63eb-47c1-9c72-71f54761a791";
#endif
            S3Helper.WriteStringToS3(JsonConvert.SerializeObject(resonanceMysql, Formatting.None), "resonance-configuration", $"{environment}/credentials/mysql/resonance.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
            Assert.IsTrue(true);
            */
        }

        [TestMethod]
        public void CreateRedshiftCredentials()
        {
            Assert.IsTrue(true);
            return;
            string environment = null;
            NpgSqlModel resonanceRedshift = null;
            NpgSqlModel tahoeRedshift = null;
            S3CredentialModel resonanceS3 = null;
            string kmsArn = null;

#if CONFIG_DEVELOPMENT
            environment = "Development";
            resonanceRedshift = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_redshift_development.serialized"));
            tahoeRedshift = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_twitch_science_redshift.serialized"));
            resonanceS3 = JsonConvert.DeserializeObject<S3CredentialModel>(File.ReadAllText($@"C:\Secrets\resonance_s3.serialized"));
            kmsArn = "arn:aws:kms:us-west-2:029773783190:key/3230f66f-4da7-4911-ae98-56afbcbd30f2";
#elif CONFIG_STAGING
            environment = "Staging";
            resonanceRedshift = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_redshift_staging.serialized"));
            tahoeRedshift = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_twitch_science_redshift.serialized"));
            resonanceS3 = JsonConvert.DeserializeObject<S3CredentialModel>(File.ReadAllText($@"C:\Secrets\resonance_s3.serialized"));
            kmsArn = "arn:aws:kms:us-west-2:029773783190:key/cc79d809-bfcc-4d2d-97f2-7376f412f1b5";
#elif CONFIG_PRODUCTION
            environment = "Production";
            resonanceRedshift = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_redshift_production.serialized"));
            tahoeRedshift = JsonConvert.DeserializeObject<NpgSqlModel>(File.ReadAllText($@"C:\Secrets\resonance_twitch_science_redshift.serialized"));
            resonanceS3 = JsonConvert.DeserializeObject<S3CredentialModel>(File.ReadAllText($@"C:\Secrets\resonance_s3.serialized"));
            kmsArn = "arn:aws:kms:us-west-2:029773783190:key/027e7a19-63eb-47c1-9c72-71f54761a791";
#endif
            S3Helper.WriteStringToS3(JsonConvert.SerializeObject(resonanceRedshift, Formatting.None), "resonance-configuration", $"{environment}/credentials/redshift/resonance.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
            S3Helper.WriteStringToS3(JsonConvert.SerializeObject(tahoeRedshift, Formatting.None), "resonance-configuration", $"{environment}/credentials/redshift/tahoe.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
            S3Helper.WriteStringToS3(JsonConvert.SerializeObject(resonanceS3, Formatting.None), "resonance-configuration", $"{environment}/credentials/s3/resonance.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
            Assert.IsTrue(true);
        }

        [TestMethod]
        public void CreateDevServiceApiKeys()
        {
            //Assert.IsTrue(true);
            //return;

            //var environment = "Development";
            //var kmsArn = "arn:aws:kms:us-west-2:029773783190:key/3230f66f-4da7-4911-ae98-56afbcbd30f2";
            var environment = "Staging";
            var kmsArn = "arn:aws:kms:us-west-2:029773783190:key/cc79d809-bfcc-4d2d-97f2-7376f412f1b5";
            var services = new string[7]
            {
                "amp",
                "auth",
                "explorer",
                "jobs",
                "salesforce",
                "twitchuserlookup",
                "twitchverifiedlink"
            };

            var data = new Dictionary<string, string>
            {
                { "api-app-key", "ABCDEF12345" },
                { "api-service-key", Guid.NewGuid().ToString() }
            };
            var bucket = "resonance-configuration";
            foreach (var service in services)
            {
                var keypath = $"{environment}/credentials/{service.ToLower()}/auth-api-key.json.gz";
                //if (S3Helper.ExistsInS3(bucket, keypath) == false)
                {
                    S3Helper.WriteStringToS3(JsonConvert.SerializeObject(data, Formatting.None), bucket, keypath, true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
                }
            }
        }

        [TestMethod]
        public void CreateResonanceOAuthServiceFiles()
        {
            Assert.IsTrue(true);
            return;

#pragma warning disable CS0219 // Variable is assigned but its value is never used
#pragma warning disable CS0162 // Unreachable code detected
            string environment = null;
            string inputManifest = null;
            string inputOAuthAmp = null;
            string inputOAuthAtlas = null;
            string inputOAuthExplorer = null;
            string kmsArn = null;

            try
            {
                /*
                environment = "Development";
                inputManifest = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Systems Manifest (Dev).json");
                inputOAuthAmp = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Amp (Dev).json");
                inputOAuthAtlas = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Atlas (Dev).json");
                inputOAuthExplorer = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Explorer (Dev).json");
                kmsArn = "arn:aws:kms:us-west-2:029773783190:key/3230f66f-4da7-4911-ae98-56afbcbd30f2";
                */
                /*
                environment = "Staging";
                inputManifest = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Systems Manifest (Staging).json");
                inputOAuthAmp = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Amp (Staging).json");
                inputOAuthAtlas = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Atlas (Staging).json");
                inputOAuthExplorer = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Explorer (Staging).json");
                kmsArn = "arn:aws:kms:us-west-2:029773783190:key/cc79d809-bfcc-4d2d-97f2-7376f412f1b5";
                */
                /*
                environment = "Production";
                inputManifest = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Systems Manifest (Production).json");
                inputOAuthAmp = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Amp (Production).json");
                inputOAuthAtlas = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Atlas (Production).json");
                inputOAuthExplorer = File.ReadAllText($@"C:\Secrets\Resonance OAuth\OAuth Explorer (Production).json");
                kmsArn = "arn:aws:kms:us-west-2:029773783190:key/027e7a19-63eb-47c1-9c72-71f54761a791";
                */

                /*
                S3Helper.WriteStringToS3(inputManifest, "resonance-configuration", $"{environment}/credentials/resonance/oauth/manifest.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
                S3Helper.WriteStringToS3(inputOAuthAmp, "resonance-configuration", $"{environment}/credentials/resonance/oauth/amp-service.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
                S3Helper.WriteStringToS3(inputOAuthAtlas, "resonance-configuration", $"{environment}/credentials/resonance/oauth/atlas-service.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
                S3Helper.WriteStringToS3(inputOAuthExplorer, "resonance-configuration", $"{environment}/credentials/resonance/oauth/explorer-service.json.gz", true, kmsArn, Amazon.S3.ServerSideEncryptionMethod.AWSKMS);
                Assert.IsTrue(true);
                */
#pragma warning restore CS0219 // Variable is assigned but its value is never used
#pragma warning restore CS0162 // Unreachable code detected
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
                Assert.IsTrue(false);
            }
        }

        [TestMethod]
        public void UpdateSalesforceCredentials()
        {
            Assert.IsTrue(true);
            return;

#if CONFIG_PRODUCTION
            string key = "salesforce/prod_credentials_jwt.serialized.encrypted;" production
#else
            string key = "salesforce/test_credentials_jwt.serialized.encrypted";
#endif

            string arn = "arn:aws:kms:us-east-1:029773783190:key/0611af9f-78f3-432d-ae85-af45507ce63a";
            
            string localFile = Path.Combine(Path.GetTempPath(), Path.GetTempFileName());

            try
            {
                UpdateSalesforceCredentials(arn, key, localFile);
            }
            finally
            {
                File.Delete(localFile);
            }
        }

        private void UpdateSalesforceCredentials(string arn, string s3path, string localFile)
        {
            string bucket = "crs-data-credentials";          

            //get the current file
            SalesforceCredentialsModel data = JsonConvert.DeserializeObject<SalesforceCredentialsModel>(AwsEncryption.Decrypt(bucket, s3path));

            //make updates to whichever fields need to be changed
            //data.ClientID = "";
            //...

            //write updates to local file
            File.WriteAllText(localFile, JsonConvert.SerializeObject(data, Formatting.None));

            //enrypt and upload to S3
            AwsEncryption.Encrypt(arn, localFile, bucket, s3path);
        }
    }
}
