﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Resonance.Core.Models.AuthModels;
using System;
using System.Collections.Generic;
using System.Security.Claims;
using System.Text;

namespace Resonance.Api.Test.Explorer
{
    [TestClass]
    public class JWT
    {
        [TestMethod]
        public void EmployeeWithRequiredMonthsServiceIsAuthorized()
        {
            var employmentCommenced = DateTime.Now.AddMonths(-3).AddDays(-1).ToString();

            var user = new ClaimsPrincipal(new ClaimsIdentity(new List<Claim> {
                new Claim(CustomClaimTypes.EmploymentCommenced, employmentCommenced, ClaimValueTypes.DateTime)
            }));

            var requirement = new MinimumMonthsEmployedRequirement(3);
            var authorizationHandler = new MinimumMonthsEmployedHandler();

            var handlers = new List<IAuthorizationRequirement> { requirement };
            var context = new AuthorizationHandlerContext(handlers, user, null);
            authorizationHandler.HandleAsync(context);

            Assert.IsTrue(context.HasSucceeded);
        }

        [TestMethod]
        public void EmployeeWithoutRequiredMonthsOfServiceDenied()
        {
            var employmentCommenced = DateTime.Now.AddMonths(-2).ToString();

            var user = new ClaimsPrincipal(new ClaimsIdentity(new List<Claim> {
                new Claim(CustomClaimTypes.EmploymentCommenced, DateTime.Now.AddMonths(-2).ToString(), ClaimValueTypes.DateTime)
            }));

            var requirement = new MinimumMonthsEmployedRequirement(3);
            var authorizationHandler = new MinimumMonthsEmployedHandler();

            var handlers = new List<IAuthorizationRequirement> { requirement };
            var context = new AuthorizationHandlerContext(handlers, user, null);
            authorizationHandler.HandleAsync(context);

            Assert.IsFalse(context.HasSucceeded);
        }
    }
}
