﻿using Resonance.Core.Models.DatabaseModels.AtlasModels;
using Resonance.Jobs.Atlas.ContractAutoExtender.Interfaces;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Api.Test.Jobs.Atlas.ContractAutoExtender.Mocks
{
    public class MockExtenderQuery : IExtenderQuery
    {

        private List<AtlasContract> _baseList;

        public MockExtenderQuery(List<AtlasContract> list)
        {
            _baseList = list;
        }

        public MockExtenderQuery()
        {

        }

        private List<AtlasContract> GetDummyContracts()
        {
            List<AtlasContract> contracts = new List<AtlasContract>
            {
                new AtlasContract{ ContractID = 1, AutoRenew = true,  StartDate = new DateTime(2019,1,1), EndDate = new DateTime(2019,12,31)},
                new AtlasContract{ ContractID = 2, AutoRenew = false,  StartDate = new DateTime(2019,1,1), EndDate = new DateTime(2019,12,31)},                
            };

            return contracts;
        }

        public IList<AtlasContract> GetContractsForAutoExtension()
        {
            return _baseList ?? GetDummyContracts();
        }        

        public int UpdateContractDB(AtlasContract contract)
        {
            if (contract.ContractID >= 500)
            { //use contractIDs 500 and up to simulate error
                return 0;
            }

            return 1;
        }
    }
}
