﻿using Amazon;
using Amazon.S3;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;

namespace Resonance.Api.Test.TwitchUploadService
{
    [TestClass]
    public class DirectServiceTest
    {
        [TestMethod]
        public void CreateAsset()
        {
            Resonance.Core.Constants.AppConfig = new Core.Models.ConfigurationModels.ApplicationConfigurationModel()
            {
                Application = new Core.Models.ConfigurationModels.ApplicationModel()
                {
                    Environment = "Development"
                }
            };
            var success = false;
            try
            {
                var accountID = "029773783190";
                var testImageBytes = File.ReadAllBytes(@"C:\Projects\Resonance\Resonance.Api.Microservices.Atlas\Atlas Upload Tester\ShouldPass\front-page.png");
                string s3Path;
                switch (Resonance.Core.Constants.AppConfig.Application.Environment)
                {
                    case "Production":
                    {
                        s3Path = "s3://twitch-upload-service/Production";
                        break;
                    }
                    case "Staging":
                    {
                        s3Path = "s3://twitch-upload-service/Staging";
                        break;
                    }
                    default:
                    {
                        s3Path = "s3://twitch-upload-service/Staging";
                        break;
                    }
                }
                var result = TwitchUploadServiceHelper.Create(new UploadRequestModel()
                {
                    Callback = new CallbackModel()
                    {
                        SnsTopicArn = "arn:aws:sns:us-west-2:995367761609:staging-upload-service-callback",
                        PubSubTopic = "default",
                        Data = testImageBytes
                    },
                    PreValidation = new ValidationModel()
                    {
                        FileSizeLessThan = "1GB"
                    },
                    Monitoring = new MonitoringModel(){
                        
                    },
                    OutputPrefix = s3Path,
                    Outputs = new List<OutputModel>()
                    {
                        new OutputModel()
                        {
                            Name = "Test",
                            AllowAnimation = false,
                            GifTransformationTimeout = 0,
                            Permissions = new PermissionsModel()
                            {
                                GrantFullControl = $"id={accountID}"
                            },
                            PostValidation = new ValidationModel()
                            {
                                FileSizeLessThan = "1GB"
                            },
                            Transformations = new List<TransformationModel>()
                            {
                                new TransformationModel()
                                {
                                    MaxHeight = new MaxHeightModel() { Height = 50 },
                                    MaxWidth = new MaxWidthModel() { Width = 50 },
                                    Crop = new CropModel()
                                    {
                                        Top = 0,
                                        Left = 0,
                                        Width = 50,
                                        Height = 50
                                    }
                                }
                            }
                        }
                    }
                });
                if (!string.IsNullOrWhiteSpace(result.UploadID) && !string.IsNullOrWhiteSpace(result.Url))
                {
                    var uploadResult = WebRequestHelper.PostData<byte[]>(result.Url, bearer: null, data: ref testImageBytes, timeout: 600);
                    success = true;
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void GetAssetStatus()
        {
            Resonance.Core.Constants.AppConfig = new Core.Models.ConfigurationModels.ApplicationConfigurationModel()
            {
                Application = new Core.Models.ConfigurationModels.ApplicationModel()
                {
                    Environment = "Development"
                }
            };
            var success = false;
            try
            {
                var result = TwitchUploadServiceHelper.Status(new StatusRequestModel()
                {
                    UploadID = "cf09e169-1cdd-406e-9ce1-9248882bd6fb"
                });
                if (!string.IsNullOrWhiteSpace(result.UploadID))
                {
                    success = true;
                }
            }
            catch(Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }

        [TestMethod]
        public void SetAssetStatus()
        {
            Resonance.Core.Constants.AppConfig = new Core.Models.ConfigurationModels.ApplicationConfigurationModel()
            {
                Application = new Core.Models.ConfigurationModels.ApplicationModel()
                {
                    Environment = "Development"
                }
            };
            var success = false;
            try
            {
                Core.Constants.TwitchUploadServiceStatus testStatus = Core.Constants.TwitchUploadServiceStatus.FEATURE_SERVICE_FAILED;
                var result = TwitchUploadServiceHelper.SetStatus(new SetStatusRequestModel()
                {
                    UploadID = "cf09e169-1cdd-406e-9ce1-9248882bd6fb",
                    Status = testStatus
                });
                var statusResult = TwitchUploadServiceHelper.Status(new StatusRequestModel()
                {
                    UploadID = "cf09e169-1cdd-406e-9ce1-9248882bd6fb"
                });
                if (!string.IsNullOrWhiteSpace(statusResult.UploadID) && statusResult.Status == testStatus)
                {
                    success = true;
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            Assert.IsTrue(success);
        }
    }
}
