using Microsoft.VisualStudio.TestTools.UnitTesting;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Models.ServiceModels.TwitchModels;

namespace Resonance.Api.Test.TwitchUserLookup
{
    [TestClass]
    public class TwitchUserController
    {
        private static readonly string logpath = $@"{TestConfig.TestLogPath}twitch-user";

        #region GET Data
        [TestMethod]
        public void GetByTwitchUserID()
        {
            try
            {
                var twitchUserID = 2;
                var url = $"{TestConfig.ApiEndpointTwitchUser}worker/twitch-user/get-by-twitch-user-id/{twitchUserID}";
                var result = WebRequestHelper.GetData(url, WebRequestHelper.AppToken);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        [TestMethod]
        public void GetByTwitchLogin()
        {
            try
            {
                var twitchLogin = "tournymasterbot";
                var url = $"{TestConfig.ApiEndpointTwitchUser}worker/twitch-user/get-by-twitch-login/{twitchLogin}";
                var result = WebRequestHelper.GetData(url, WebRequestHelper.AppToken);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        [TestMethod]
        public void GetUsersByTwitchUserIDList()
        {
            try
            {
                var data = new List<long>()
                {
                    1, 2, 3, 4, 5, 6, 7, 8, 9, 38665491, 53831996, 19571641, 111181680
                };
                var url = $"{TestConfig.ApiEndpointTwitchUser}worker/twitch-user/get-by-list-twitch-user-id";
                var content = JsonConvert.SerializeObject(data);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.AppToken, ref content, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch(Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        [TestMethod]
        public void GetUsersByTwitchUserLoginList()
        {
            try
            {
                var twitchUserLogins = new List<string>()
                {
                        "tournymasterbot", "ninja", "grandpoobear", "thedragonfeeney"
                };
                var url = $"{TestConfig.ApiEndpointTwitchUser}worker/twitch-user/get-by-list-twitch-login";
                var content = JsonConvert.SerializeObject(twitchUserLogins);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.AppToken, ref content, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }
        
        #endregion

        #region INSERT / UPDATE
        [TestMethod]
        public void InsertUpdateTwitchUser()
        {
            try
            {
                var testList = new TwitchUserListModel()
                {
                    Data = new TwitchUserModel[9]
                    {
                        new TwitchUserModel()
                        {
                            TwitchUserID = 1,
                            TwitchLogin = $"tournymasterbot",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 2,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 3,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 4,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 5,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 6,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 7,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 8,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        },
                        new TwitchUserModel()
                        {
                            TwitchUserID = 9,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            IsActive = true,
                            InactiveReason = Core.Constants.TwitchInactiveStatus.Active
                        }
                    }
                };
                var url = $"{TestConfig.ApiEndpointTwitchUser}worker/twitch-user/bulk-insert-update-twitch-user";
                var content = JsonConvert.SerializeObject(testList);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.ServiceToken, ref content, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }
        #endregion

        #region Inactive Users
        [TestMethod]
        public void UpdateInactiveUser()
        {
            try
            {
                var testList = new TwitchBannedOrDeletedUserModel()
                {
                    UserID = 9,
                    Reason = Core.Constants.TwitchInactiveStatus.DMCA
                };
                var url = $"{TestConfig.ApiEndpointTwitchUser}worker/twitch-user/update-inactive-user";
                var content = JsonConvert.SerializeObject(testList);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.ServiceToken, ref content, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }


        [TestMethod]
        public void UpdateInactiveUserList()
        {
            try
            {
                var testList = new TwitchBannedOrDeletedUserListModel()
                {
                    Data = new TwitchBannedOrDeletedUserModel[6]
                    {
                        new TwitchBannedOrDeletedUserModel()
                        {
                            UserID = 1,
                            Reason = Core.Constants.TwitchInactiveStatus.TOS
                        },
                        new TwitchBannedOrDeletedUserModel()
                        {
                            UserID = 2,
                            Reason = Core.Constants.TwitchInactiveStatus.DMCA
                        }
                        ,
                        new TwitchBannedOrDeletedUserModel()
                        {
                            UserID = 3,
                            Reason = Core.Constants.TwitchInactiveStatus.BannedUndefined
                        },
                        new TwitchBannedOrDeletedUserModel()
                        {
                            UserID = 4,
                            Reason = Core.Constants.TwitchInactiveStatus.SelfDeleted
                        },
                        new TwitchBannedOrDeletedUserModel()
                        {
                            UserID = 5,
                            Reason = Core.Constants.TwitchInactiveStatus.Unknown
                        },
                        new TwitchBannedOrDeletedUserModel()
                        {
                            UserID = 6,
                            Reason = Core.Constants.TwitchInactiveStatus.Active
                        }
                    }
                };
                var url = $"{TestConfig.ApiEndpointTwitchUser}worker/twitch-user/bulk-update-inactive-user";
                var content = JsonConvert.SerializeObject(testList);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.ServiceToken, ref content, isToken: true);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }
        #endregion
    }
}