using Resonance.Core.Models.ApiModels.TwitchModels;
using Resonance.Core.Models.ApiModels.YoutubeModels;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Newtonsoft.Json;
using System;
using System.Diagnostics;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Models.ServiceModels.TwitchModels;

namespace Resonance.Api.Test.TwitchverifiedLink
{
    [TestClass]
    public class TwitchVerifiedLinkController
    {
        private static readonly string logpath = $@"{TestConfig.TestLogPath}twitch-verified-link";

        #region GET Data
        [TestMethod]
        public void GetByTwitchUserID()
        {
            try
            {
                var twitchUserID = 1;
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/get-by-twitch-user-id/{twitchUserID}";
                var result = WebRequestHelper.GetData(url, WebRequestHelper.AppToken);
                if(result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        [TestMethod]
        public void GetByTwitchLogin()
        {
            try
            {
                var twitchLogin = "tournymasterbot";
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/get-by-twitch-login/{twitchLogin}";
                var result = WebRequestHelper.GetData(url, WebRequestHelper.AppToken);
                if (result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }


        [TestMethod]
        public void GetUsersByTwitchUserIDList()
        {
            try
            {
                var twitchUserIDs = new UserIDListModel()
                {
                    UserIDs = new long[]
                    {
                        1, 38665491, 53831996, 19571641, 111181680
                    }
                };
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/get-by-list-twitch-user-id";
                var content = JsonConvert.SerializeObject(twitchUserIDs);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.AppToken, ref content, isToken: true);
                if (result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch(Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        [TestMethod]
        public void GetUsersByTwitchUserLoginList()
        {
            try
            {
                var twitchUserLogins = new UserLoginListModel()
                {
                    TwitchLogins = new string[]
                    {
                        "tournymasterbot", "ninja", "grandpoobear", "thedragonfeeney"
                    }
                };
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/get-by-list-twitch-user-id";
                var content = JsonConvert.SerializeObject(twitchUserLogins);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.AppToken, ref content, isToken: true);
                if (result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        [TestMethod]
        public void GetUsersByYoutubeTagsList()
        {
            try
            {
                var youtubeTags = new UserTagListModel()
                {
                    Tags = new string[]
                    {
                        "UCTournyMasterBot", "UC-lHJZR3Gqxm24_Vd_AJ5Yw", "UC7_YxT-KID8kRbqZo7MyscQ", "UCAW-NpUFkMyCNrvRSSGIvDQ", "UC-6czyMkxDi8E8akPl0c7_w"
                    }
                };
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/get-by-list-youtube-tags";
                var content = JsonConvert.SerializeObject(youtubeTags);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.AppToken, ref content, isToken: true);
                if (result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        [TestMethod]
        public void GetAllUsers()
        {
            try
            {
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/get-all";
                var result = WebRequestHelper.GetData(url, WebRequestHelper.AppToken);
                if (result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    //Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }
        #endregion

        #region INSERT / UPDATE
        /// <summary>
        /// Todo: Confirm specific users are updated
        /// </summary>
        [TestMethod]
        public void InsertUpdateTwitchVerifiedLink()
        {
            try
            {
                var testList = new TwitchVerifiedLinkListModel()
                {
                    Data = new TwitchVerifiedLinkModel[5]
                    {
                        new TwitchVerifiedLinkModel()
                        {
                            TwitchUserID = 1,
                            TwitchLogin = $"tournymasterbot",
                            YoutubeTag = $"UCTournyMasterBot",
                            AddedBy = "System",
                            LastUpdated = DateTime.UtcNow
                        },
                        new TwitchVerifiedLinkModel()
                        {
                            TwitchUserID = 2,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            YoutubeTag = $"UCasdf{Guid.NewGuid().ToString().Substring(0, 10)}",
                            AddedBy = "System",
                            LastUpdated = DateTime.UtcNow
                        },
                        new TwitchVerifiedLinkModel()
                        {
                            TwitchUserID = 3,
                            TwitchLogin = $"test{Guid.NewGuid().ToString().Substring(0, 10)}",
                            YoutubeTag = $"UCasdf{Guid.NewGuid().ToString().Substring(0, 10)}",
                            AddedBy = "System",
                            LastUpdated = DateTime.UtcNow
                        },
                        new TwitchVerifiedLinkModel()
                        {
                            TwitchUserID = 4,
                            TwitchLogin = $"testStatic1",
                            YoutubeTag = $"UCasdfStatic1",
                            AddedBy = "System",
                            LastUpdated = DateTime.UtcNow
                        },
                        new TwitchVerifiedLinkModel()
                        {
                            TwitchUserID = 5,
                            TwitchLogin = $"testStatic2",
                            YoutubeTag = $"UCasdfStatic2",
                            AddedBy = "TournyMasterBot",
                            LastUpdated = DateTime.UtcNow
                        }
                    }
                };
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/bulk-insert-update";
                var content = JsonConvert.SerializeObject(testList);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.ServiceToken, ref content, isToken: true);
                if (result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }

        #endregion

        #region DELETE
        /// <summary>
        /// Todo: Update to confirm specific users are gone
        /// </summary>
        [TestMethod]
        public void DeleteTwitchVerifiedLink()
        {
            try
            {
                var testList = new TwitchDeletedUserListModel()
                {
                    DeletedUsers = new TwitchDeletedUserModel[2]
                    {
                        new TwitchDeletedUserModel()
                        {
                            TwitchUserID = 1,
                            YoutubeTag = $"UCasdf{Guid.NewGuid().ToString().Substring(0, 10)}",
                        },
                        new TwitchDeletedUserModel()
                        {
                            TwitchUserID = 3,
                            YoutubeTag = $"UCasdf{Guid.NewGuid().ToString().Substring(0, 10)}",
                        }
                    }
                };
                var url = $"{TestConfig.ApiEndpointTwitchVerifiedLink}worker/twitch-verified-link/delete-by-twitch-user-id";
                var content = JsonConvert.SerializeObject(testList);
                var result = WebRequestHelper.PostData(url, WebRequestHelper.ServiceToken, ref content, isToken: true);
                if (result != null && result.IsSuccess)
                {
                    Assert.IsTrue(!string.IsNullOrWhiteSpace(result.Data));
                    Debug.Print(result.Data);
                }
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
                throw;
            }
        }
        #endregion
    }
}