﻿using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ServiceModels.ExplorerModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Commands.SlackCommands
{
    public static partial class SlackCommand
    {
        public static string GetTop5Countries(SlackCommandMetaModel data)
        {
            var newline = (char)10;
            string response = "No country data found.";

            var command = data?.Text?.Trim()?.Split(' ');

            if(command == null || command.Length != 2)
            {
                return response;
            }

            try
            {
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var query = conn.GetCommand())
                    {
                        query.CommandText =
                        $@"
                            select
                                a.country_code,
                                coalesce(b.country_name, 'Unknown') as country_name,
                                a.country_count,
                                a.rank
                            from cubes.amp_channel_country_ranking_top5 as a
                            left join warehouse.dim_country as b
                                on a.country_code = b.country_code_two_letter
                            where channel_id = @userid
                            order by rank
                            ;
                        ";
                        query.Parameters.AddWithValue("@userid", command[1]);
                        using (var reader = query.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                var builder = new StringBuilder();
                                while (reader.Read())
                                {
                                    builder.Append($"Results for *{command[1]}* {newline}*{reader.GetString(0)} ({reader.GetString(1)}):* {reader.GetInt64(2).ToString("N0")} [Rank: {reader.GetInt64(3)}]{newline}");
                                }
                                response = builder.ToString();
                            }
                            else
                            {
                                response = $"No country data found for {command[1]}";
                            }
                        }
                    }
                }
            }
            catch(Exception ex)
            {
                Log.Error(ex);
                response = "Error during country lookup";
            }

            return response;
        }
    }
}
