﻿using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.StringHelpers;
using Resonance.Core.Models.ApiModels.ExplorerModels;
using Resonance.Core.Models.ServiceModels.TwitchModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Commands.SlackCommands
{
    public static partial class SlackCommand
    {
        public static string GetDefinition(string content)
        {
            string result = string.Empty;
            if (string.IsNullOrWhiteSpace(content))
            {
                result = "Usage: [LookupType] [SearchTerm]";
            }
            else
            {
                var items = content.Split(' ');
                if (items.Length == 2)
                {
                    switch (items[0].ToLower())
                    {
                        case "table":
                        {
                            /*
                            using (var conn = DBManagerMysql.GetConnection(true))
                            {
                                using (var command = conn.GetCommand())
                                {
                                    command.CommandTimeout = 600;
                                    command.CommandText = "";
                                    using (var reader = command.ExecuteReader())
                                    {
                                        if (reader.HasRows)
                                        {
                                            while (reader.Read())
                                            {

                                            }
                                        }
                                    }
                                }
                            }*/
                            result = "Table lookup in progress";
                            break;
                        }
                        case "view":
                        {
                            /*
                            using (var conn = DBManagerMysql.GetConnection(true))
                            {
                                using (var command = conn.GetCommand())
                                {
                                    command.CommandTimeout = 600;
                                    command.CommandText = "";
                                    using (var reader = command.ExecuteReader())
                                    {
                                        if (reader.HasRows)
                                        {
                                            while (reader.Read())
                                            {

                                            }
                                        }
                                    }
                                }
                            }*/
                            result = "View lookup in progress";
                            break;
                        }
                        case "procedure":
                        {
                            /*
                            using (var conn = DBManagerMysql.GetConnection(true))
                            {
                                using (var command = conn.GetCommand())
                                {
                                    command.CommandTimeout = 600;
                                    command.CommandText = "";
                                    using (var reader = command.ExecuteReader())
                                    {
                                        if (reader.HasRows)
                                        {
                                            while (reader.Read())
                                            {

                                            }
                                        }
                                    }
                                }
                            }*/
                            result = "Procedure lookup in progress";
                            break;
                        }
                        case "property":
                        case "field":
                        case "column":
                        {
                            /*
                            using (var conn = DBManagerMysql.GetConnection(true))
                            {
                                using (var command = conn.GetCommand())
                                {
                                    command.CommandTimeout = 600;
                                    command.CommandText = "";
                                    using (var reader = command.ExecuteReader())
                                    {
                                        if (reader.HasRows)
                                        {
                                            while (reader.Read())
                                            {

                                            }
                                        }
                                    }
                                }
                            }*/
                            result = "Column lookup in progress";
                            break;
                        }
                        default:
                        {
                            result = $"No items were found for {items[0]}::{items[1]}";
                            break;
                        }
                    }
                }
                else
                {
                    result = "Usage: [LookupType] [SearchTerm]";
                }
            }

            return result;
        }

        public static string GetViewbot(string content)
        {
            string result = string.Empty;
            if (string.IsNullOrWhiteSpace(content))
            {
                result = "Usage: [login | user_id]";
            }
            else
            {
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandTimeout = 600;
                        command.CommandText =
                        $@"
                            select
                                a.ChannelID,
                                b.Login,
                                a.BeforeAvg,
                                a.MergedAvg,
                                a.BestGuessAvg,
                                a.Data
                            from {Constants.DatabaseSchema}microservice_twitch_viewbot as a
                            inner join {Constants.DatabaseSchema}microservice_twitch_user_details as b
                                on a.ChannelID = b.ChannelID
                            where 
                                a.ChannelID = @identifier
                                or b.Login = @identifier
                            ;
                        ";
                        command.Parameters.AddWithValue("@identifier", content);
                        using (var reader = new DataReaderWithMeasurements(command, null, "get_viewbot").MysqlReader)
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var data = new ViewbotDisplayModel()
                                    {
                                        ChannelID = (long)reader["ChannelID"],
                                        Login = (string)reader["Login"],
                                        BeforeAvg = reader["BeforeAvg"] == System.DBNull.Value ? null : (float?)((float)reader["BeforeAvg"]),
                                        MergedAvg = reader["MergedAvg"] == System.DBNull.Value ? null : (float?)((float)reader["MergedAvg"]),
                                        BestGuessAvg = reader["BestGuessAvg"] == System.DBNull.Value ? null : (float?)((float)reader["BestGuessAvg"]),
                                    };
                                    result = $@"Channel ID: {data.ChannelID}, Login: {data.Login}, Before Avg: {data.BeforeAvg?.ToString("N0") ?? "N/A"}, Merged Avg: {data.MergedAvg?.ToString("N0") ?? "N/A"}, Best Guess Avg: {data.BestGuessAvg?.ToString("N0") ?? "N/A"}";
                                }
                            }
                            else
                            {
                                result = $@"Unable to find a user with the identifier of {content}";
                            }
                        }
                    }
                }
            }

            return result;
        }

    }
}
