﻿using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ServiceModels.ExplorerModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Resonance.Core.Commands.SlackCommands
{
    public static partial class SlackCommand
    {
        public static string GetUser(string content)
        {
            string result = string.Empty;

            try
            {
                var users = new Dictionary<long, string>();

                if (string.IsNullOrWhiteSpace(content))
                {
                    result = "A user id or name must be supplied. IE: '/user tournymasterbot' or '/user 38665491'";
                }
                else
                {
                    using (var conn = DBManagerMysql.GetConnection(true))
                    {
                        using (var command = conn.GetCommand())
                        {
                            command.CommandTimeout = 600;
                            command.CommandText =
                            $@"
                                select ChannelID, Login
                                from {Constants.DatabaseSchema}microservice_twitch_user_listing_past_360_days
                                where
                                    Login = @data 
                                    or ChannelID = @data
                            ";
                            command.Parameters.AddWithValue("@data", content);
                            using (var reader = command.ExecuteReader())
                            {
                                if (reader.HasRows)
                                {
                                    while (reader.Read())
                                    {
                                        var item = new SlackTwitchUserModel()
                                        {
                                            TwitchUserID = reader.GetInt64(0),
                                            Login = reader.GetString(1)
                                        };

                                        if (!users.ContainsKey(item.TwitchUserID))
                                        {
                                            users.Add(item.TwitchUserID, item.Login);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                if (users.Count <= 0)
                {
                    result = $"No Resonance user found for '{content}'";
                }
                else if (users.Count == 1)
                {
                    result = $"User ID: {users.First().Key}, Login: {users.First().Value}";
                }
                else if (users.Count > 1)
                {
                    var builder = new StringBuilder();
                    foreach (var user in users)
                    {
                        builder.Append($"User ID: {user.Key}, Login: {user.Value}|");
                    }
                    result = $@"Multiple users found, {builder.ToString()}";
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }

            return result;
        }
    }
}
