﻿namespace Resonance.Core
{
    public static class ConstantsPermissions
    {
        public static class Amp
        {
            // Permission Group Lists for easy access on controllers
            public const string GeneralAccess = "General Access";
            public const string ContentTechTeam = "General Access,Content Tech Team";
            public const string ServiceUpdate = "Service Update,Content Tech Team";
            public const string CanCreateRequests = "Can Create Requests";
            public const string CanApproveRequests = "Can Approve Requests";
            public const string CanSeeRevenueData = "Can See Revenue Data";
            public const string CanSeeAllRequests = "Can See All Requests";

            public static readonly string[] CheckPublicPermissions = new string[5]
            {
                GeneralAccess,
                CanCreateRequests,
                CanApproveRequests,
                CanSeeRevenueData,
                CanSeeAllRequests
            };
        }

        public static class Atlas
        {            
            /// <summary>
            /// Allows a user to view any non-restricted data
            /// </summary>
            public const string GeneralAccess = "General Access";
            /// <summary>
            /// Allows unrestricted access to the system
            /// </summary>
            public const string Administrator = "Administrator";
            /// <summary>
            /// Allows a user to view contracts for any Premium Content Creator
            /// </summary>
            public const string CanViewAnyContract = "Can View Any Contract";
            /// <summary>
            /// Allows a user to create/edit any pcc/product/event/season/etc that they are assigned to. 
            /// For new PCC, it allows them to create an entry and be assigned to it
            /// </summary>
            public const string CanManageOwnPremiumContentCreators = "Can Manage Own Premium Content Creators";
            /// <summary>
            /// Allows a user to create/edit any pcc/product/event/season/etc
            /// </summary>
            public const string CanManageAnyPremiumContentCreators = "Can Manage Any Premium Content Creators";
            /// <summary>
            /// Allows a user to masquerade as a specific Ldap user
            /// </summary>
            public const string CanMasqueradeLdap = "Can Masquerade Ldap";
            /// <summary>
            /// Allows a user to masquerade as a specific api key
            /// </summary>
            public const string CanMasqueradeApiKey = "Can Masquerade ApiKey";
            /// <summary>
            /// Prevents any form of masquerade
            /// </summary>
            public const string BlockMasquerade = "Block Masquerade";
        }
    }
}
