﻿using Microsoft.AspNetCore.Http;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Extensions
{
    public static class IFormExtensions
    {
        public static string GetFirstOrDefault(this IFormCollection form, string key, bool allowNulls = true, bool throwOnNull = false)
        {
            if (form.ContainsKey(key))
            {
                return form[key];
            }
            else
            {
                if (allowNulls)
                {
                    return null;
                }
                else
                {
                    if (throwOnNull)
                    {
                        throw new ArgumentNullException("key");
                    }
                    else
                    {
                        return string.Empty;
                    }
                }
            }
        }
    }
}
