﻿using Resonance.Core;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels.ExplorerModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Resonance.Core.Extensions
{
    public static class MigrationPermissionExtensions
    {
        /// <summary>
        /// Tuple: Success/Fail, HttpStatusCode, Message
        /// </summary>
        public static Tuple<bool, int, string> Validate(this MigrationPermissionRequestModel request)
        {
            var success = true;
            var statuscode = 200;
            var errorList = new StringBuilder();

            try
            {
                var validateProject = request.ValidateProject();

                if (!validateProject.Item1)
                {
                    success = false;
                    statuscode = statuscode == 200 ? validateProject.Item2 : statuscode;
                    errorList.AppendLine(validateProject.Item3);
                }
                
                var validateEnvironment = request.ValidateEnvironment();
                if (!validateEnvironment.Item1)
                {
                    success = false;
                    statuscode = statuscode == 200 ? validateEnvironment.Item2 : statuscode;
                    errorList.AppendLine(validateEnvironment.Item3);
                }
            }
            catch(Exception ex)
            {
                Log.Error(ex);
            }
            return new Tuple<bool, int, string>(success, statuscode, errorList.ToString());
        }

        /// <summary>
        /// Tuple: Success/Fail, HttpStatusCode, Message
        /// </summary>
        public static Tuple<bool, int, string> ValidateProject(this MigrationPermissionRequestModel request)
        {
            var success = false;
            var statuscode = 500;
            var message = string.Empty;

            try
            {
                if (!string.IsNullOrWhiteSpace(request.Project))
                {
                    var projectExists = ((Constants.SiteID[])Enum.GetValues(typeof(Constants.SiteID))).Any(x => request.Project == x.ToString() && x != Constants.SiteID.Unknown);
                    if (projectExists)
                    {
                        success = true;
                        statuscode = 200;
                        message = string.Empty;
                    }
                    else
                    {
                        success = false;
                        statuscode = 400;
                        message = $"{request.Project} does not exist";
                    }
                }
                else
                {
                    success = false;
                    statuscode = 400;
                    message = "Project name is null or empty";
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                statuscode = 400;
                message = "Failed to process Project name";
            }

            return new Tuple<bool, int, string>(success, statuscode, message);
        }

        /// <summary>
        /// Tuple: Success/Fail, HttpStatusCode, Message
        /// </summary>
        public static Tuple<bool, int, string> ValidateEnvironment(this MigrationPermissionRequestModel request)
        {
            var success = false;
            var statuscode = 500;
            var message = string.Empty;

            try
            {
                if(string.IsNullOrWhiteSpace(request.SourceEnvironment) || string.IsNullOrWhiteSpace(request.TargetEnvironment))
                {
                    success = false;
                    statuscode = 400;
                    message = "Source environment or Target environment is null or empty";
                }
                else
                {
                    if(request.SourceEnvironment == request.TargetEnvironment)
                    {
                        success = false;
                        statuscode = 400;
                        message = "Source environment matches Target environment. This is not allowed.";
                    }
                    else
                    {
                        var sourceEnvironmentExists = ((Constants.ValidEnvironments[])Enum.GetValues(typeof(Constants.ValidEnvironments))).Any(x => request.SourceEnvironment == x.ToString() && x != Constants.ValidEnvironments.Unknown);
                        var targetEnvironmentExists = ((Constants.ValidEnvironments[])Enum.GetValues(typeof(Constants.ValidEnvironments))).Any(x => request.TargetEnvironment == x.ToString() && x != Constants.ValidEnvironments.Unknown);

                        bool shouldContinue = sourceEnvironmentExists && targetEnvironmentExists;
                        if (!shouldContinue)
                        {
                            success = false;
                            statuscode = 400;
                            message = $"Environment not defined: Source Exists? {sourceEnvironmentExists}, Target Exists? {targetEnvironmentExists}";
                        }
                        else
                        {
                            success = true;
                            statuscode = 200;
                            message = string.Empty;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                statuscode = 400;
                message = "Failed to process environment";
            }

            return new Tuple<bool, int, string>(success, statuscode, message);
        }

        public static Tuple<bool, int, string> SavePermissions(this MigrationPermissionRequestModel request)
        {
            var success = false;
            var statuscode = 500;
            var message = string.Empty;

            try
            {
                success = true;
                statuscode = 200;
                message = string.Empty;
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                statuscode = 400;
                message = "Failed to save data";
            }

            return new Tuple<bool, int, string>(success, statuscode, message);
        }
    }
}
