﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Resonance.Core.Extensions
{
    public static class PartitionExtension
    {
        public static IEnumerable<IEnumerable<T>> Partition<T>(this IEnumerable<T> source, Int32 size)
        {
            for (int i = 0; i < Math.Ceiling(source.Count() / (Double)size); i++)
                yield return new List<T>(source.Skip(size * i).Take(size));
        }
    }
}
