﻿using Microsoft.AspNetCore.Http;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Extensions
{
    public static class ResponseExtensions
    {
        public static string GetCookieNameFromResponse(this HttpResponse response, string cookieName, bool exactMatch = true)
        {
            foreach (var headers in response.Headers.Values)
                foreach (var header in headers)
                    if (exactMatch)
                    {
                        if (header.StartsWith($"{cookieName}="))
                        {
                            var p1 = header.IndexOf('=');
                            var p2 = header.IndexOf(';');
                            return header.Substring(p1 + 1, p2 - p1 - 1);
                        }
                    }
                    else
                    {
                        if (header.StartsWith($"{cookieName}"))
                        {
                            var p1 = header.IndexOf('=');
                            return header.Substring(0, p1);
                        }
                    }
            return null;
        }

        public static string GetCookieValueFromResponse(this HttpResponse response, string cookieName, bool exactMatch = true)
        {
            foreach (var headers in response.Headers.Values)
                foreach (var header in headers)
                    if (exactMatch)
                    {
                        if (header.StartsWith($"{cookieName}="))
                        {
                            var p1 = header.IndexOf('=');
                            var p2 = header.IndexOf(';');
                            return header.Substring(p1 + 1, p2 - p1 - 1);
                        }
                    }
                    else
                    {
                        if (header.StartsWith($"{cookieName}"))
                        {
                            var p1 = header.IndexOf('=');
                            var p2 = header.IndexOf(';');
                            return header.Substring(p1 + 1, p2 - p1 - 1);
                        }
                    }
            return null;
        }
    }
}
