﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Text;

namespace Resonance.Core.Helpers.ApiHelpers
{
    public class ResonanceWebClient : WebClient
    {
        public int Timeout { get; set; }
        public ResonanceWebClient(int timeout = 100)
        {
            Timeout = timeout;

        }

        protected override WebRequest GetWebRequest(Uri address)
        {
            WebRequest request = base.GetWebRequest(address);
            request.Timeout = Timeout * 1000;
            request.Headers.Add("Content-Type", "application/json");
            request.Headers.Add("Accepts", "application/json");
            request.ContentType = "application/json";
            return request;
        }
    }
}
