﻿using Amazon.CloudWatch;
using Newtonsoft.Json;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels.TwitchModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Helpers.ApiHelpers
{
    public static class TwitchLivelineAPIHelper
    {
        private const string _metricSuccessKey = "liveline_service_success";
        private const string _metricErrorKey = "liveline_service_error";

        public static string Endpoint
        {
            get
            {
                switch(Constants.AppConfig.Application.Environment)
                {
                    case "Development":
                        return "http://vpce-0815a64c0a4360988-phdsmn53.vpce-svc-0e4e8f90d47bca00d.us-west-2.vpce.amazonaws.com/";
                    case "Staging":
                        return "https://main.staging.liveline.twitch.a2z.com/";
                    case "Production":
                        return "https://main.production.liveline.twitch.a2z.com/";
                    default:
                        return null;
                }
            }
        }

        public static LivelineGetStreamSummaryResponse GetStreamSummaryByGameName(string gameName)
        {
            var payload = new LivelineGetStreamSummaryRequest() { GroupBy = "AGGREGATIONFIELD_CATEGORY_ID", Filters = new[] { new LivelineGetStreamSummaryRequestFilter() { FilterKey = "AGGREGATIONFILTER_CATEGORY_NAME", FilterValues = new[] { gameName.ToLower() } } } };
            var response = WebRequestHelper.PostData($"{Endpoint}twirp/liveline.Liveline/GetStreamSummary", null, ref payload);
            if (response.IsSuccess)
            {
                CloudwatchHelper.EnqueueMetricRequest(_metricSuccessKey, 1, null, StandardUnit.Count);
                return JsonConvert.DeserializeObject<LivelineGetStreamSummaryResponse>(response.Data);
            }
            else
            {
                CloudwatchHelper.EnqueueMetricRequest(_metricErrorKey, 1, null, StandardUnit.Count);
                return null;
            }
        }

        public static LivelineGetStreamsResponse GetChannelResponseByChannelIDs(IEnumerable<string> channelIDs)
        {
            var payload = new { channel_ids = channelIDs };
            var response = WebRequestHelper.PostData($"{Endpoint}twirp/liveline.Liveline/GetStreamsByChannelIDs", null, ref payload);
            if (response.IsSuccess)
            {
                CloudwatchHelper.EnqueueMetricRequest(_metricSuccessKey, 1, null, StandardUnit.Count);
                return JsonConvert.DeserializeObject<LivelineGetStreamsResponse>(response.Data);
            }
            else
            {
                CloudwatchHelper.EnqueueMetricRequest(_metricErrorKey, 1, null, StandardUnit.Count);
                return null;
            }
        }
    }
}
