﻿using Amazon;
using Amazon.CloudWatch;
using Amazon.Lambda.APIGatewayEvents;
using Amazon.Lambda.Model;
using Newtonsoft.Json;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels;
using Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading.Tasks;

namespace Resonance.Core.Helpers.ApiHelpers
{
    public static class TwitchUploadServiceHelper
    {
        private const string _metricSuccessKey = "upload_service_success";
        private const string _metricErrorKey = "upload_service_error";

        public static string Endpoint
        {
            get
            {
                switch (Constants.AppConfig.Application.Environment)
                {
                    case "Development":
                        // For this to work, you need to have a host entry for the following, and be connected to the CrsData aws vpn
                        // 172.29.13.119 staging-upload-service-77557386f2f939a0.elb.us-west-2.amazonaws.com
                        // That machine is our staging server
                        // It's the attached EIN for the service endpoint to our VPC, it's not normally ever supposed to be used like this, but essentially the routing on our end is very intentionally setup so that once it hits the endpoint service gateway, it looks like requests are coming from the VPC they're attached to
                        return "http://staging-upload-service-77557386f2f939a0.elb.us-west-2.amazonaws.com/";
                    case "Staging":
                        return "https://staging.upload-service.twitch.a2z.com/";
                    case "Production":
                        return "https://prod.upload-service.twitch.a2z.com/";
                    default:
                        return null;
                }
            }
        }

        public static UploadResponseModel Create(UploadRequestModel request)
        {
            UploadResponseModel result = null;
            try
            {
                var uploadUrl = "twirp/code.justin.tv.web.upload_service.Uploader/Create";
                var response = WebRequestHelper.PostData($"{Endpoint}{uploadUrl}", null, ref request);
                if (response.IsSuccess)
                {
                    CloudwatchHelper.EnqueueMetricRequest(_metricSuccessKey, 1, null, StandardUnit.Count);
                    result = JsonConvert.DeserializeObject<UploadResponseModel>(response.Data);                    
                }
            }
            catch(Exception ex)
            {
                CloudwatchHelper.EnqueueMetricRequest(_metricErrorKey, 1, null, StandardUnit.Count);
                Log.Error(ex);
            }
            return result;
        }

        public static EmptyModel SetStatus(SetStatusRequestModel status)
        {
            EmptyModel result = null;
            try
            {
                var uploadUrl = "twirp/code.justin.tv.web.upload_service.Uploader/SetStatus";
                var response = WebRequestHelper.PostData($"{Endpoint}{uploadUrl}", null, ref status);
                if (response.IsSuccess)
                {
                    CloudwatchHelper.EnqueueMetricRequest(_metricSuccessKey, 1, null, StandardUnit.Count);
                    result = JsonConvert.DeserializeObject<EmptyModel>(response.Data);
                }
            }
            catch (Exception ex)
            {
                CloudwatchHelper.EnqueueMetricRequest(_metricErrorKey, 1, null, StandardUnit.Count);
                Log.Error(ex);
            }
            return result;
        }

        public static StatusResponseModel Status(StatusRequestModel status)
        {
            StatusResponseModel result = null;
            try
            {
                var uploadUrl = "twirp/code.justin.tv.web.upload_service.Uploader/Status";
                var response = WebRequestHelper.PostData($"{Endpoint}{uploadUrl}", null, ref status, timeout: 30);
                if (response.IsSuccess)
                {
                    CloudwatchHelper.EnqueueMetricRequest(_metricSuccessKey, 1, null, StandardUnit.Count);
                    result = JsonConvert.DeserializeObject<StatusResponseModel>(response.Data);
                }
            }
            catch (Exception ex)
            {
                CloudwatchHelper.EnqueueMetricRequest(_metricErrorKey, 1, null, StandardUnit.Count);
                Log.Error(ex);
            }
            return result;
        }
    }
}
