﻿using Amazon.CloudWatch;
using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using Resonance.Core.Extensions;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Models.ApiModels.TwitchModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;

namespace Resonance.Core.Helpers.ApiHelpers
{
    public class TwitchUsersServiceHelpers
    {
        public static string Endpoint
        {
            get
            {
                switch (Constants.AppConfig.Application.Environment)
                {
                    case "Development":
                        return "https://dev.users-service.twitch.a2z.com/";
                    case "Staging":
                        return "https://dev.users-service.twitch.a2z.com/";
                    case "Production":
                        return "https://prod.users-service.twitch.a2z.com/";
                    default:
                        return null;
                }
            }
        }

        public static TwitchUsersServiceGetUsersResponse GetUsers(HttpContext context, string nameSearch)
        {
            WebClient client = new WebClient();
            string url = $"{Endpoint}users?login_like={nameSearch}%25";

            try
            {
                var response = client.DownloadString(url);
                var result = JsonConvert.DeserializeObject<TwitchUsersServiceGetUsersResponse>(response);
                CloudwatchHelper.EnqueueMetricRequest("user_service_success", 1, context, StandardUnit.Count);
                return result;
            }
            catch (Exception)
            {
                CloudwatchHelper.EnqueueMetricRequest("user_service_fail", 1); 
                return null;
            }
        }

        public static TwitchUsersServiceGetUsersResponse GetUserByLogin(HttpContext context, string login)
        {
            WebClient client = new WebClient();
            string url = $"{Endpoint}users?login={login}";

            try
            {
                var response = client.DownloadString(url);
                var result = JsonConvert.DeserializeObject<TwitchUsersServiceGetUsersResponse>(response);
                CloudwatchHelper.EnqueueMetricRequest("user_service_success", 1, context, StandardUnit.Count);
                return result;
            }
            catch (Exception)
            {
                CloudwatchHelper.EnqueueMetricRequest("user_service_fail", 1, context, StandardUnit.Count);
                return null;
            }
        }

        public static TwitchUsersServiceGetUsersResponse GetUsers(HttpContext context, IEnumerable<long> userIDs)
        {
            if(!userIDs.Any())
            {
                return new TwitchUsersServiceGetUsersResponse() { Results = new List<TwitchUsersServiceUser>() };
            }
            var partitionedUserIDs = userIDs.Partition(300);
            var response = new TwitchUsersServiceGetUsersResponse() { Results = new List<TwitchUsersServiceUser>() };
            foreach (var partition in partitionedUserIDs)
            {
                WebClient client = new WebClient();
                string url = $"{Endpoint}users?{string.Join("&", partition.Select(userID => $"id={userID}").ToArray())}";

                try
                {
                    var serviceResponse = client.DownloadString(url);
                    response.Results.AddRange(JsonConvert.DeserializeObject<TwitchUsersServiceGetUsersResponse>(serviceResponse).Results);
                    CloudwatchHelper.EnqueueMetricRequest("user_service_success", 1, context, StandardUnit.Count);
                    StatsDHelpers.StatsDHelper.Counter(measurement: "success", measurementType: "users_service_call");
                }
                catch (Exception)
                {
                    CloudwatchHelper.EnqueueMetricRequest("user_service_fail", 1, context, StandardUnit.Count);
                    StatsDHelpers.StatsDHelper.Counter(measurement: "error", measurementType: "users_service_call");
                }
            }
            return response;
        }
    }
}
