﻿using Microsoft.AspNetCore.Http;
using Resonance.Core.Models.AuthModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Microservices.Exceptions;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ConfigurationModels.Permissions;

namespace Resonance.Core.Helpers.AuthHelpers
{
    public class ApiUserAuthDataReader : UserAuthDataReader
    {   
        public ApiUserAuthDataReader(string apiKey) : base(apiKey)
        {     
            base.AuthType = UserAuthType.ApiKey;
        }
        
        public override UserAuthData ReadData(UserAuthDataReaderConfig config)        
        {
            string apiKey = config.ApiKey;
            string remoteAddress = config.RemoteAddress;

            var resonancePermissions = new List<string>();
            var roles = new List<string>();            
            string userid = null;

            try
            {                
                var permissions = new List<string>();

                // Key: RoleID
                // Value: List<TokenID>
                foreach (var rolemap in Constants.Permissions.RoleToTokenMap.Where(x => x.Value.Contains(apiKey)))
                {
                    bool addRole = false;
                    foreach (var tokenname in rolemap.Value.Where(x => x.Contains(apiKey)))
                    {
                        IEnumerable<TokenModel> tokens = null;
                        tokens = Constants.Permissions.Tokens.Where(x => x.TokenName == tokenname && x.TokenName == apiKey);
                        foreach (var tokendata in tokens)
                        {
                            if (tokendata.WhitelistedIPSource == null || tokendata.WhitelistedIPSource.Length == 0 ||
                                (tokendata.WhitelistedIPSource.Length == 1 && tokendata.WhitelistedIPSource[0] == "") ||
                                tokendata.WhitelistedIPSource.Contains(remoteAddress))
                            {
                                addRole = true;
                                userid = tokendata.TokenID;
                            }
                        }
                    }
                    if (addRole)
                    {
                        roles.Add(rolemap.Key);
                    }
                }

                foreach (var role in roles)
                {
                    if (Constants.Permissions.RoleToPermissionMap.ContainsKey(role))
                    {
                        resonancePermissions.AddRange(Constants.Permissions.RoleToPermissionMap[role]);
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }

            return new UserAuthData { Roles = roles, Permissions = resonancePermissions, UserID = userid };            
        }        
    }
}
