﻿using Newtonsoft.Json;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels;
using Resonance.Core.Models.AuthModels;
using Resonance.Microservices.Exceptions;
using System;
using System.Threading;

namespace Resonance.Core.Helpers.ApiHelpers
{
    public static class AuthHelpers
    {
        private static readonly string authServerURL = Constants.AppConfig.Endpoints.Auth;

        public static AuthTokenData ValidateAuthToken(string siteID, ref string token)
        {
            try
            {
                var request = new VerifyJWTTokenRequest() { SiteID = siteID, JwtToken = token };
                WebRequestResponse result = null;
                result = WebRequestHelper.PostData<VerifyJWTTokenRequest>($"{authServerURL}worker/auth/verify-jwt/", WebRequestHelper.ServiceToken, ref request, needsAuth: false);

                if (result == null || !result.IsSuccess || string.IsNullOrWhiteSpace(result.Data))
                {
                    throw new InvalidOperationException("result");
                }

                ApiResponse<AuthTokenData> tokenData = JsonConvert.DeserializeObject<ApiResponse<AuthTokenData>>(result.Data);
                if(tokenData.ResponseData == default(AuthTokenData))
                {
                    throw new AuthTokenValidationException($@"An error occured that resulted in a default AuthTokenData object. {result}");
                }
                if (tokenData.ResponseData.Expires <= DateTime.UtcNow)
                {
                    throw new AuthTokenValidationException("Token Is no longer Valid");
                }
                return tokenData.ResponseData;
            }
            catch(AuthTokenValidationException ex)
            {
                throw ex;
            }
            catch (Exception ex)
            {
                if(Constants.AppConfig.Application.Environment == "Development")
                {
                    Log.Warn($@"Authentication Error: {ex}");
                }
                throw;
            }
        }
    }
}
