﻿using Microsoft.AspNetCore.Http;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.AuthModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Microservices.Exceptions;

namespace Resonance.Core.Helpers.AuthHelpers
{
    public class LDAPUserAuthDataReader : UserAuthDataReader
    {        
        public LDAPUserAuthDataReader(string jwtToken) : base(jwtToken)
        {
            base.AuthType = UserAuthType.Token;   
        }
        
        public override UserAuthData ReadData(UserAuthDataReaderConfig config)
        {
            AuthTokenData tokenData = config.TokenData;
            var permissionlist = new List<string>();
            var rolelist = new List<string>();

            try
            {
                try
                {
                    if (tokenData != null && tokenData.Groups != null)
                    {
                        var resonanceLdapGroups = Constants.Permissions.LdapGroups.Where(x => tokenData.Groups.Contains(x.LdapGroupName) || x.LdapGroupName == "*").ToArray();

                        foreach (var group in resonanceLdapGroups)
                        {
                            var roles = Constants.Permissions.RoleToLdapGroupMap.Where(x => x.Value.Contains(group.LdapGroupName)).Select(x => x.Key);
                            rolelist.AddRange(roles);
                            foreach (var role in roles)
                            {
                                if (Constants.Permissions.RoleToPermissionMap.ContainsKey(role))
                                {
                                    permissionlist.AddRange(Constants.Permissions.RoleToPermissionMap[role]);
                                }
                            }
                        }
                    }

                    if (Constants.Permissions.LdapNames.Any(x => x.LdapName == tokenData.User))
                    {
                        var roles = Constants.Permissions.RoleToLdapNameMap.Where(x => x.Value.Contains(tokenData.User)).Select(x => x.Key);
                        rolelist.AddRange(roles);
                        foreach (var role in roles)
                        {
                            if (Constants.Permissions.RoleToPermissionMap.ContainsKey(role))
                            {
                                permissionlist.AddRange(Constants.Permissions.RoleToPermissionMap[role]);
                            }
                        }
                    }
                }
                catch (AuthTokenValidationException ex)
                {
                    Log.Error(ex);
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }

            return new UserAuthData { Permissions = permissionlist, Roles = rolelist, UserID = tokenData != null ? tokenData.User : null };            
        }
    }
}
