﻿using Microsoft.AspNetCore.Http;
using Resonance.Core.Models.AuthModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Resonance.Core.Helpers.AuthHelpers
{
    public enum UserAuthType
    {
        Token = 1,
        ApiKey = 2
    }

    public class UserAuthDataReaderConfig
    {
        private string _apiKey;
        public string ApiKey
        {
            get
            {
                return _apiKey;
            }
        }

        private string _remoteAddress;
        public string RemoteAddress
        {
            get
            {
                return _remoteAddress;
            }
        }
        private AuthTokenData _tokenData;
        public AuthTokenData TokenData
        {
            get
            {
                return _tokenData;
            }
        }

        public static UserAuthDataReaderConfig New()
        {
            return new UserAuthDataReaderConfig();
        }

        public UserAuthDataReaderConfig WithApiKey(string apiKey, string remoteAddress)
        {
            _apiKey = apiKey;
            _remoteAddress = remoteAddress;
            return this;
        }        

        public UserAuthDataReaderConfig WithToken(AuthTokenData tokenData)
        {
            _tokenData = tokenData;
            return this;
        }
    }

    public abstract class UserAuthDataReader
    {   
        public string AuthValue { get; protected set; }
        
        public UserAuthType AuthType { get; protected set; }

        public UserAuthDataReader(string authValue)
        {
            AuthValue = authValue;
        }        
        
        abstract public UserAuthData ReadData(UserAuthDataReaderConfig config);
    }
}
