﻿using Amazon;
using Amazon.SecurityToken;
using Resonance.Core.Models.ConfigurationModels.Aws;
using System;

namespace Resonance.Core.Helpers.AwsHelpers
{
    public static class AwsCredentialHelper
    {
        public static AwsCredentialModel GetAwsCredentials()
        {
            try
            {
                var client = new AmazonSecurityTokenServiceClient(new AmazonSecurityTokenServiceConfig() { StsRegionalEndpoints = Amazon.Runtime.StsRegionalEndpointsValue.Regional, RegionEndpoint = RegionEndpoint.USWest2 });
                var tokenTask = client.GetSessionTokenAsync();
                tokenTask.Wait();
                if (tokenTask.IsCompleted)
                {
                    var token = tokenTask.Result;
                    var credentials = new AwsCredentialModel(token);
                    return credentials;
                }
                else
                {
                    throw new InvalidOperationException($"Aws Session Token Task Failed, this should be manually reviewed for reasons. (Debugging)");
                }
            }
            catch (Exception)
            {
                throw;
            }
        }
    }
}
