﻿using Amazon.Runtime;
using Amazon.Runtime.CredentialManagement;

namespace Resonance.Core.Helpers.AwsHelpers
{
    public static class STSHelper
    {
        public static AWSCredentials GetCredentials(string profileName)
        {
            var sharedFile = new SharedCredentialsFile();
            var stsCredentialSuccess = sharedFile.TryGetProfile(profileName, out CredentialProfile credentialProfile);
            AWSCredentialsFactory.TryGetAWSCredentials(credentialProfile, sharedFile, out AWSCredentials credentials);
            return credentials;
        }
    }
}
