﻿using Resonance.Core.Helpers.ApiHelpers;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Helpers.ConfigurationHelpers
{
    public static class AuthServiceHelper
    {
        private static Dictionary<Constants.SiteID, OAuthHelpers> oauthServices = new Dictionary<Constants.SiteID, OAuthHelpers>();

        public static void Initialize()
        {
            foreach (Constants.SiteID item in Enum.GetValues(typeof(Constants.SiteID)))
            {
                if (item != Constants.SiteID.Unknown)
                {
                    oauthServices.Add(item, new OAuthHelpers(item));
                }
            }
        }

        public static OAuthHelpers GetOAuthHelper(Constants.SiteID site)
        {
            if (oauthServices.ContainsKey(site))
            {
                return oauthServices[site];
            }
            else
            {
                return null;
            }
        }
    }
}
