﻿using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Linq;
using Resonance.Core.Helpers.LoggingHelpers;
using System.Reflection;
using Resonance.Core.Helpers.FileHelpers;

namespace Resonance.Core.Helpers.ConfigurationHelpers
{
    public static class CorsHelper
    {
        public static IServiceCollection AddCorsFile(this IServiceCollection services, string policyName, string corsFile, Action notConfigured = null)
        {            
            services.AddCors(o => o.AddPolicy(policyName, builder =>
            {
                string localPath = FileHelper.GetRelativePath(corsFile);
                if (File.Exists(localPath))
                {
                    var lines = File.ReadAllLines(localPath);

                    builder.WithOrigins(lines)
                    .AllowAnyMethod()
                    .AllowAnyHeader()
                    .AllowCredentials();                    
                }
                else
                {
                    Log.Error($"Couldnt find {corsFile} in {Directory.GetCurrentDirectory()}");
                    notConfigured?.Invoke();
                }
            }));

            return services;
        }

        public static IServiceCollection ConfigureCorsFilesForEnvironments(this IServiceCollection services)        
        {
            foreach (string env in new string[] { Constants.AppConfig.Application.Environment })
            {
                string value = $"cors.{env}.txt";

                services.AddCorsFile(env, value, () =>
                {
                    Log.Error($"CORS file '{value}' does not exist");
                });
            }

            return services;
        }
    }
}
