﻿using Npgsql;
using System;

namespace Resonance.Core.Helpers.DatabaseHelpers
{
    public static class CommandParameterHelper
    {
        public static string AddParameters<T>(ref NpgsqlCommand command, ref T[] parameters)
        {
            if(parameters == null || parameters.Length == 0)
            {
                return null;
            }
            var keys = new string[parameters.Length];
            var counter = 0;
            foreach(var param in parameters)
            {
                var key = $@"@parameter_{counter}";
                keys[counter] = key;
                command.Parameters.AddWithValue(key, param);
                counter++;
            }
            return string.Join(",", keys);
        }

        public static void CreateFilterQueryWhereClause<T>(ref NpgsqlCommand command, ref Tuple<string, T>[] parameters)
        {
            AddFilterQueryParameters(ref command, ref parameters);
            throw new NotImplementedException();
        }

        public static void AddFilterQueryParameters<T>(ref NpgsqlCommand command, ref Tuple<string, T>[] parameters)
        {
            if (parameters == null || parameters.Length == 0)
            {
                return;
            }
            var keys = new string[parameters.Length];
            var counter = 0;
            foreach (var param in parameters)
            {
                var key = $@"@{param.Item1}_{Guid.NewGuid().ToString().Replace("-", "")}";
                keys[counter] = key;
                command.Parameters.AddWithValue(key, param.Item2);
                counter++;
            }
        }

    }
}
