﻿using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Helpers.StatsDHelpers;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Diagnostics;
using System.Threading;
using System.Threading.Tasks;
using static Resonance.Core.Constants;

namespace Resonance.Core.Helpers.DatabaseHelpers
{
    public static class DBManagerSqlServer
    {
        static DBManagerSqlServer()
        {

        }

        public static SqlConnection ResonanceSqlConnection(bool open = true)
        {
            throw new NotImplementedException($"Implementation is currently disabled. To re-enable, remove the throw from code.");

/*
            try
            {
                var credentials = AwsHelpers.AwsCredentialHelper.GetAwsCredentials();
                var builder = new SqlConnectionStringBuilder()
                {
                    DataSource = "resonance-dev.xxxx.us-west-2.rds.amazonaws.com",
                    InitialCatalog = "Resonance",
                    UserID = "resonance_dev",
                    Password = "password",
                    MultipleActiveResultSets = true,
                    MaxPoolSize = 1024,
                    Encrypt = true,
                    TrustServerCertificate = true
                };
                var conn = new SqlConnection(builder.ConnectionString);
                if (open)
                {
                    conn.Open();
                }
                return conn;
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                throw;
            }
            */
        }

        /// <summary>
        /// Creates a sql command for the given sql connection
        /// </summary>
        public static SqlCommand GetCommand(this SqlConnection conn, string commandText = "")
        {
            var command = new SqlCommand()
            {
                Connection = conn,
                CommandText = commandText,
            };
            return command;
        }

        public static void ExecuteNonQueryWithMeasurements(this SqlCommand command, string logname = null)
        {
            var stopwatch = new Stopwatch();
            stopwatch.Start();
            command.ExecuteNonQuery();
            stopwatch.Stop();
            NLog.LogManager.GetCurrentClassLogger().Debug($"{logname ?? "Unnamed"}:MeasureExecuteNonQuery took {stopwatch.ElapsedMilliseconds}ms");

            if (!string.IsNullOrWhiteSpace(logname))
            {
                StatsDHelper.CounterLong(measurement: $"query", measurementType: logname, val: stopwatch.ElapsedMilliseconds, location: "ExecuteNonQueryWithMeasurements", additionalTags: $",db_type=sqlserver");
            }
        }

        public static T ExecuteScalarWithMeasurements<T>(this SqlCommand command, string logname = null)
        {
            var stopwatch = new Stopwatch();
            stopwatch.Start();
            var result = (T)command.ExecuteScalar();
            stopwatch.Stop();
            NLog.LogManager.GetCurrentClassLogger().Debug($"{logname ?? "Unnamed"}:MeasureExecuteScalar took {stopwatch.ElapsedMilliseconds}ms");
            if (!string.IsNullOrWhiteSpace(logname))
            {
                StatsDHelper.CounterLong(measurement: $"query", measurementType: logname, val: stopwatch.ElapsedMilliseconds, location: "ExecuteScalarWithMeasurements", additionalTags: $",db_type=sqlserver");
            }
            return result;
        }
    }
}
