﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;

namespace Resonance.Core.Helpers.DatabaseHelpers
{
    public static class FieldHelper
    {
        public static string[] GetFields(Type modelType)
        {
            var fields = new List<string>();
            foreach(var property in modelType.GetProperties())
            {
                foreach(var customAttribute in property.CustomAttributes)
                {
                    foreach(var namedAttribute in customAttribute.NamedArguments)
                    {
                        switch (namedAttribute.MemberName)
                        {
                            case "PropertyName":
                            {
                                fields.Add(namedAttribute.TypedValue.Value.ToString());
                                break;
                            }
                        }
                    }

                    foreach(var namedAttribute in customAttribute.ConstructorArguments)
                    {
                        fields.Add(namedAttribute.Value.ToString());
                    }
                }
            }
            return fields.Distinct().ToArray();
        }
    }
}
