﻿using System;
using System.ComponentModel;
using System.Linq;
using System.Reflection;

namespace Resonance.Core.Helpers.EnumHelpers
{
    public static class EnumHelper
    {
        /// <summary>
        /// Usage:  int value = 1; string description = EnumHelper.GetEnumDescription((MyEnum)value);
        /// </summary>
        public static string GetEnumDescription(Enum value)
        {
            FieldInfo fi = value.GetType().GetField(value.ToString());
            DescriptionAttribute[] attributes = fi.GetCustomAttributes(typeof(DescriptionAttribute), false) as DescriptionAttribute[];

            if (attributes != null && attributes.Any())
            {
                return attributes.First().Description;
            }

            return value.ToString();
        }
    }
}
